/*
 * Decompiled with CFR 0.152.
 */
package rsw.chart;

import java.awt.Color;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import rsw.chart.RswChart;
import rsw.chart.RswChartAxisLabel;
import rsw.chart.RswChartValue;
import rsw.chart.RswChartValuesRect;

public class RswChartSeries {
    private String name = "";
    private Color color = null;
    List values = new ArrayList();
    private boolean showValueLabels = false;
    RswChart chart = null;
    private boolean visible = true;
    private float alpha = 1.0f;

    public RswChartSeries(String aName, Color aColor) {
        this.name = aName;
        this.color = aColor;
    }

    public RswChartSeries(String aName) {
        this.name = aName;
    }

    public RswChartSeries(RswChartSeries source) {
        this.name = source.getName();
        this.color = source.getColor();
        this.showValueLabels = source.isShowValueLables();
        this.chart = source.getChart();
        this.visible = source.isVisible();
        this.alpha = source.getAlpha();
        ListIterator it = source.values.listIterator();
        while (it.hasNext()) {
            this.addValue((RswChartValue)it.next());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public void addValue(RswChartValue value) {
        if (!this.values.contains(value)) {
            this.values.add(value);
        }
        Collections.sort(this.values);
    }

    public RswChartValue addXY(double aX, double aY) {
        RswChartValue tmp = new RswChartValue(aX, aY);
        this.addValue(tmp);
        return tmp;
    }

    public RswChartValue addXYWidth(double aX, double aY, double aWidth) {
        RswChartValue tmp = new RswChartValue(aX, aY, aWidth);
        this.addValue(tmp);
        return tmp;
    }

    public RswChartValue addXYLabel(double aX, double aY, String aLabel) {
        RswChartValue tmp = new RswChartValue(aX, aY, aLabel);
        this.addValue(tmp);
        return tmp;
    }

    public RswChartValue addXYWidthLabel(double aX, double aY, double aWidth, String aLabel) {
        RswChartValue tmp = new RswChartValue(aX, aY, aWidth, aLabel);
        this.addValue(tmp);
        return tmp;
    }

    public void removeValue(RswChartValue value) {
        if (this.values.contains(value)) {
            this.values.remove(value);
        }
    }

    public RswChartValuesRect getValuesRect() {
        return new RswChartValuesRect(this.chart);
    }

    public boolean isShowValueLables() {
        return this.showValueLabels;
    }

    public void setShowValueLabels(boolean value) {
        this.showValueLabels = value;
    }

    public RswChart getChart() {
        return this.chart;
    }

    public void setChart(RswChart value) {
        this.chart = value;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float value) {
        this.alpha = value;
    }

    public double getPieValue() {
        double tmp = 0.0;
        ListIterator it = this.values.listIterator();
        while (it.hasNext()) {
            double val;
            if (this.chart.getChartMode() == 3 || this.chart.getChartMode() == 2) {
                tmp += Math.abs(((RswChartValue)it.next()).getY());
                continue;
            }
            if (this.chart.getChartMode() != 4 || !((val = Math.abs(((RswChartValue)it.next()).getY())) > tmp)) continue;
            tmp = val;
        }
        if (this.values.size() > 0 && this.chart.getChartMode() == 3) {
            tmp /= (double)this.values.size();
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateData(Connection connection, String table, String xValueFieldName, String yValueFieldName, String widthValueFieldName, String labelFieldName) {
        boolean tmp = true;
        if (connection != null) {
            Statement st = null;
            ResultSet rs = null;
            try {
                st = connection.createStatement();
                rs = st.executeQuery("select * from " + table);
                int i = 1;
                double x = 0.0;
                double y = 0.0;
                double width = 0.0;
                String label = null;
                if (this.values != null) {
                    this.values.clear();
                }
                if (this.chart.xAxisLabels != null) {
                    this.chart.xAxisLabels.clear();
                }
                while (rs.next()) {
                    try {
                        x = rs.getDouble(xValueFieldName);
                    }
                    catch (Exception e) {
                        x = i;
                    }
                    try {
                        y = rs.getDouble(yValueFieldName);
                    }
                    catch (Exception e) {
                        y = i;
                    }
                    try {
                        width = rs.getDouble(widthValueFieldName);
                    }
                    catch (Exception e) {
                        width = 0.0;
                    }
                    try {
                        label = rs.getString(labelFieldName);
                    }
                    catch (Exception e) {
                        label = null;
                    }
                    this.addXYWidth(x, y, width);
                    if (label != null) {
                        this.chart.xAxisLabels.add(new RswChartAxisLabel(x, label));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println(e);
                tmp = false;
                return tmp;
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {}
                return tmp;
            }
        }
        return tmp;
    }

    public String toString() {
        return this.name;
    }
}

