/*
 * Decompiled with CFR 0.152.
 */
package rsw.chart;

import java.awt.Color;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import rsw.chart.RswChartFillSeries;
import rsw.chart.RswChartSeries;
import rsw.chart.RswChartValue;

public class RswChartGanttSeries
extends RswChartFillSeries {
    public RswChartGanttSeries(String aName, Color aColor) {
        super(aName, aColor);
    }

    public RswChartGanttSeries(String aName) {
        super(aName);
    }

    public RswChartGanttSeries(RswChartSeries source) {
        super(source);
    }

    public double getMinDistance() {
        RswChartValue v;
        double y1 = 0.0;
        double y2 = 0.0;
        double d = 1000000.0;
        List yVals = this.chart.getGanttValues();
        Collections.sort(yVals, new Comparator(){

            public int compare(Object o1, Object o2) {
                RswChartValue v1 = (RswChartValue)o1;
                RswChartValue v2 = (RswChartValue)o2;
                if (v1.getY() < v2.getY()) {
                    return -1;
                }
                if (v1.getY() > v2.getY()) {
                    return 1;
                }
                return 0;
            }
        });
        ListIterator it = yVals.listIterator();
        if (it.hasNext()) {
            v = (RswChartValue)it.next();
            y1 = v.getY();
        }
        while (it.hasNext()) {
            v = (RswChartValue)it.next();
            y2 = v.getY();
            if (y2 - y1 > 0.0 && y2 - y1 < d) {
                d = y2 - y1;
            }
            y1 = y2;
        }
        return Math.abs(d * 0.5);
    }
}

