/*
 * Decompiled with CFR 0.152.
 */
package rsw.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import rsw.chart.RswChart;
import rsw.chart.RswChartAreaSeries;
import rsw.chart.RswChartAxisLabelEditorFrame;
import rsw.chart.RswChartBarSeries;
import rsw.chart.RswChartBubbleSeries;
import rsw.chart.RswChartDotSeries;
import rsw.chart.RswChartFillSeries;
import rsw.chart.RswChartGanttSeries;
import rsw.chart.RswChartLineSeries;
import rsw.chart.RswChartSeries;

public class RswChartEditorFrame
extends JDialog {
    private RswChart chart = null;
    private DefaultTreeModel treeModel = null;
    private DefaultMutableTreeNode chartNode = null;
    private DefaultMutableTreeNode axisNode = null;
    private DefaultMutableTreeNode xAxisNode = null;
    private DefaultMutableTreeNode yAxisNode = null;
    private DefaultMutableTreeNode pieAxisNode = null;
    private DefaultMutableTreeNode seriesListNode = null;
    private DefaultMutableTreeNode selectedNode = null;
    private RswChartSeries selectedSeries = null;
    private boolean initSeriesPanel = false;
    private JLabel axisLabel;
    private JPanel axisPanel;
    private JPanel buttonPanel;
    private JCheckBox chartAllowMovingCheckBox;
    private JCheckBox chartAllowWheelZoomingCheckBox;
    private JCheckBox chartAllowZoomingCheckBox;
    private JCheckBox chartAntiAliasingCheckBox;
    private JLabel chartAntiAliasingLabel;
    private JComboBox chartAreaModeComboBox;
    private JLabel chartAreaModeLabel;
    private JComboBox chartBarModeComboBox;
    private JLabel chartBarModeLabel;
    private JButton chartColor1Button;
    private JLabel chartColor1Label;
    private JPanel chartColor1Panel;
    private JButton chartColor2Button;
    private JLabel chartColor2Label;
    private JPanel chartColor2Panel;
    private JLabel chartFillClientAreaLabel;
    private JComboBox chartFillModeComboBox;
    private JComboBox chartGradientFillDirectionComboBox;
    private JLabel chartGradientFillDirectionLabel;
    private JLabel chartLegendLabel;
    private JComboBox chartModeComboBox;
    private JLabel chartModeLabel;
    private JLabel chartMouseEventsLabel;
    private JCheckBox chartShowLegendCheckBox;
    private JLabel chartTitleLabel;
    private JTextField chartTitleTextField;
    private JButton closeButton;
    private JPanel generalPanel;
    private JLabel headlineLabel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JPanel mainPanel;
    private JCheckBox pieAxisDrawGridCheckBox;
    private JLabel pieAxisDrawGridLabel;
    private JPanel pieAxisPanel;
    private JComboBox pieAxisScaleModeComboBox;
    private JLabel pieAxisScaleModeLabel;
    private JLabel pieAxisTextLabel;
    private JTextField pieAxisTextTextField;
    private JLabel seriesAlphaLabel;
    private JSpinner seriesAlphaSpinner;
    private JCheckBox seriesAlwaysCirclesCheckBox;
    private JLabel seriesAlwaysCirclesLabel;
    private JComboBox seriesClassComboBox;
    private JLabel seriesClassLabel;
    private JButton seriesColorButton;
    private JLabel seriesColorLabel;
    private JPanel seriesColorPanel;
    private JComboBox seriesDotTypeComboBox;
    private JLabel seriesDotTypeLabel;
    private JCheckBox seriesDrawDotsCheckBox;
    private JLabel seriesDrawDotsLabel;
    private JComboBox seriesGradientFillComboBox;
    private JComboBox seriesGradientFillDirectionComboBox;
    private JLabel seriesGradientFillDirectionLabel;
    private JLabel seriesGradientFillLabel;
    private JLabel seriesListLabel;
    private JPanel seriesListPanel;
    private JLabel seriesNameLabel;
    private JTextField seriesNameTextField;
    private JPanel seriesPanel;
    private JCheckBox seriesShowLabelsCheckBox;
    private JLabel seriesShowLabelsLabel;
    private JLabel seriesStrokeWidthLabel;
    private JSpinner seriesStrokeWidthSpinner;
    private JCheckBox seriesVisibleCheckBox;
    private JLabel seriesVisibleLabel;
    private JTree tree;
    private JCheckBox xAxisAutoCalcCheckBox;
    private JCheckBox xAxisDrawGridCheckBox;
    private JLabel xAxisDrawGridLabel;
    private JButton xAxisEditLablesButton;
    private JLabel xAxisLabelRotationLabel;
    private JSpinner xAxisLabelRotationSpinner;
    private JCheckBox xAxisLabelsCheckBox;
    private JLabel xAxisLabelsLabel;
    private JFormattedTextField xAxisMaxFormattedTextField;
    private JLabel xAxisMaxLabel;
    private JFormattedTextField xAxisMinFormattedTextField;
    private JLabel xAxisMinLabel;
    private JPanel xAxisPanel;
    private JLabel xAxisTextLabel;
    private JTextField xAxisTextTextField;
    private JLabel xAxisWertebereichLabel;
    private JCheckBox yAxisAutoCalcCheckBox;
    private JCheckBox yAxisDrawGridCheckBox;
    private JLabel yAxisDrawGridLabel;
    private JButton yAxisEditLablesButton;
    private JCheckBox yAxisLabelsCheckBox;
    private JLabel yAxisLabelsLabel;
    private JFormattedTextField yAxisMaxFormattedTextField;
    private JLabel yAxisMaxLabel;
    private JFormattedTextField yAxisMinFormattedTextField;
    private JLabel yAxisMinLabel;
    private JPanel yAxisPanel;
    private JLabel yAxisTextLabel;
    private JTextField yAxisTextTextField;
    private JLabel yAxisWertebereichLabel;

    public RswChartEditorFrame(RswChart aChart, Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.chart = aChart;
        this.chartToComponents();
        this.generalPanel.setVisible(false);
        this.xAxisPanel.setVisible(false);
        this.initTree();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        this.setLocation(new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2));
    }

    public RswChartEditorFrame(RswChart aChart, Dialog owner, boolean modal) {
        super(owner, modal);
        this.initComponents();
        this.chart = aChart;
        this.chartToComponents();
        this.generalPanel.setVisible(false);
        this.xAxisPanel.setVisible(false);
        this.initTree();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        this.setLocation(new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2));
    }

    public RswChart getChart() {
        return this.chart;
    }

    public void setChart(RswChart value) {
        this.chart = value;
        this.chartToComponents();
    }

    private int alphaToPercent(float alpha) {
        return Math.round((1.0f - alpha) * 100.0f);
    }

    private float percentToAlpha(int percent) {
        return 1.0f - (float)percent / 100.0f;
    }

    private void initTree() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(null);
        DefaultTreeCellRenderer r = new DefaultTreeCellRenderer();
        r.setLeafIcon(null);
        r.setClosedIcon(null);
        r.setOpenIcon(null);
        this.tree.setCellRenderer(r);
        this.treeModel = new DefaultTreeModel(top);
        this.tree.setModel(this.treeModel);
        this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                RswChartEditorFrame.this.selectedNode = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
                if (RswChartEditorFrame.this.selectedNode == RswChartEditorFrame.this.chartNode) {
                    RswChartEditorFrame.this.headlineLabel.setText("Allgemeine Einstellungen");
                    RswChartEditorFrame.this.generalPanel.setPreferredSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.generalPanel.setMinimumSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.generalPanel.setVisible(true);
                    RswChartEditorFrame.this.axisPanel.setVisible(false);
                    RswChartEditorFrame.this.xAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.yAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.pieAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesListPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesPanel.setVisible(false);
                    RswChartEditorFrame.this.pack();
                } else if (RswChartEditorFrame.this.selectedNode == RswChartEditorFrame.this.axisNode) {
                    RswChartEditorFrame.this.generalPanel.setVisible(false);
                    RswChartEditorFrame.this.headlineLabel.setText("Achsen");
                    RswChartEditorFrame.this.axisPanel.setPreferredSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.axisPanel.setMinimumSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.axisPanel.setVisible(true);
                    RswChartEditorFrame.this.xAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.yAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.pieAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesListPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesPanel.setVisible(false);
                    RswChartEditorFrame.this.pack();
                } else if (RswChartEditorFrame.this.selectedNode == RswChartEditorFrame.this.xAxisNode) {
                    RswChartEditorFrame.this.generalPanel.setVisible(false);
                    RswChartEditorFrame.this.axisPanel.setVisible(false);
                    RswChartEditorFrame.this.headlineLabel.setText("X-Achse");
                    RswChartEditorFrame.this.xAxisPanel.setPreferredSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.xAxisPanel.setMinimumSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.xAxisPanel.setVisible(true);
                    RswChartEditorFrame.this.yAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.pieAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesListPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesPanel.setVisible(false);
                    RswChartEditorFrame.this.pack();
                } else if (RswChartEditorFrame.this.selectedNode == RswChartEditorFrame.this.yAxisNode) {
                    RswChartEditorFrame.this.generalPanel.setVisible(false);
                    RswChartEditorFrame.this.axisPanel.setVisible(false);
                    RswChartEditorFrame.this.xAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.headlineLabel.setText("Y-Achse");
                    RswChartEditorFrame.this.yAxisPanel.setPreferredSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.yAxisPanel.setMinimumSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.yAxisPanel.setVisible(true);
                    RswChartEditorFrame.this.pieAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesListPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesPanel.setVisible(false);
                    RswChartEditorFrame.this.pack();
                } else if (RswChartEditorFrame.this.selectedNode == RswChartEditorFrame.this.pieAxisNode) {
                    RswChartEditorFrame.this.generalPanel.setVisible(false);
                    RswChartEditorFrame.this.axisPanel.setVisible(false);
                    RswChartEditorFrame.this.xAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.yAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.headlineLabel.setText("Torten-Achse");
                    RswChartEditorFrame.this.pieAxisPanel.setPreferredSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.pieAxisPanel.setMinimumSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.pieAxisPanel.setVisible(true);
                    RswChartEditorFrame.this.seriesListPanel.setVisible(false);
                    RswChartEditorFrame.this.seriesPanel.setVisible(false);
                    RswChartEditorFrame.this.pack();
                } else if (RswChartEditorFrame.this.selectedNode == RswChartEditorFrame.this.seriesListNode) {
                    RswChartEditorFrame.this.generalPanel.setVisible(false);
                    RswChartEditorFrame.this.axisPanel.setVisible(false);
                    RswChartEditorFrame.this.xAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.yAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.pieAxisPanel.setVisible(false);
                    RswChartEditorFrame.this.headlineLabel.setText("Serien");
                    RswChartEditorFrame.this.seriesListPanel.setPreferredSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.seriesListPanel.setMinimumSize(new Dimension(400, 400));
                    RswChartEditorFrame.this.seriesListPanel.setVisible(true);
                    RswChartEditorFrame.this.seriesPanel.setVisible(false);
                    RswChartEditorFrame.this.pack();
                } else {
                    Object o = RswChartEditorFrame.this.selectedNode.getUserObject();
                    if (o != null && o instanceof RswChartSeries) {
                        RswChartEditorFrame.this.selectedSeries = (RswChartSeries)o;
                        RswChartEditorFrame.this.generalPanel.setVisible(false);
                        RswChartEditorFrame.this.axisPanel.setVisible(false);
                        RswChartEditorFrame.this.xAxisPanel.setVisible(false);
                        RswChartEditorFrame.this.yAxisPanel.setVisible(false);
                        RswChartEditorFrame.this.pieAxisPanel.setVisible(false);
                        RswChartEditorFrame.this.seriesListPanel.setVisible(false);
                        RswChartEditorFrame.this.seriesToComponents(RswChartEditorFrame.this.selectedSeries);
                        RswChartEditorFrame.this.headlineLabel.setText(RswChartEditorFrame.this.selectedSeries.getName());
                        RswChartEditorFrame.this.seriesPanel.setPreferredSize(new Dimension(400, 400));
                        RswChartEditorFrame.this.seriesPanel.setMinimumSize(new Dimension(400, 400));
                        RswChartEditorFrame.this.seriesPanel.setVisible(true);
                        RswChartEditorFrame.this.pack();
                    }
                }
            }
        });
        this.chartNode = new DefaultMutableTreeNode("Allgemeine Einstellungen");
        top.add(this.chartNode);
        this.axisNode = new DefaultMutableTreeNode("Achsen");
        top.add(this.axisNode);
        this.xAxisNode = new DefaultMutableTreeNode("X-Achse");
        this.axisNode.add(this.xAxisNode);
        this.yAxisNode = new DefaultMutableTreeNode("Y-Achse");
        this.axisNode.add(this.yAxisNode);
        this.pieAxisNode = new DefaultMutableTreeNode("Torten-Achse");
        this.axisNode.add(this.pieAxisNode);
        this.seriesListNode = new DefaultMutableTreeNode("Serien");
        top.add(this.seriesListNode);
        ListIterator it = this.chart.seriesList.listIterator();
        while (it.hasNext()) {
            this.seriesListNode.add(new DefaultMutableTreeNode(it.next()));
        }
        this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)this.axisNode.getFirstChild()).getPath()));
        this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)this.seriesListNode.getFirstChild()).getPath()));
        this.tree.setSelectionPath(new TreePath(this.chartNode.getPath()));
    }

    private void chartToComponents() {
        if (this.chart != null) {
            this.chartTitleTextField.setText(this.chart.getTitle());
            this.chartModeComboBox.setSelectedIndex(this.chart.getChartMode() - 1);
            this.chartShowLegendCheckBox.setSelected(this.chart.isShowLegend());
            this.chartAreaModeComboBox.setSelectedIndex(this.chart.getAreaMode() - 1);
            this.chartBarModeComboBox.setSelectedIndex(this.chart.getBarMode() - 1);
            int fm = this.chart.getFillMode();
            boolean enableColor1 = fm == 2 || fm == 3;
            boolean enableColor2 = fm == 3;
            this.chartFillModeComboBox.setSelectedIndex(fm - 1);
            this.chartColor1Panel.setBackground(this.chart.getColor1());
            this.chartColor2Panel.setBackground(this.chart.getColor2());
            this.chartGradientFillDirectionComboBox.setSelectedIndex(this.chart.getGradientDirection() - 1);
            this.chartColor1Label.setEnabled(enableColor1);
            this.chartColor1Panel.setEnabled(enableColor1);
            this.chartColor1Button.setEnabled(enableColor1);
            this.chartColor2Label.setEnabled(enableColor2);
            this.chartColor2Panel.setEnabled(enableColor2);
            this.chartColor2Button.setEnabled(enableColor2);
            this.chartGradientFillDirectionLabel.setEnabled(enableColor2);
            this.chartGradientFillDirectionComboBox.setEnabled(enableColor2);
            this.chartAntiAliasingCheckBox.setSelected(this.chart.isAntiAliasing());
            this.xAxisTextTextField.setText(this.chart.getXAxisText());
            this.xAxisAutoCalcCheckBox.setSelected(this.chart.isAutoCalcXAxis());
            this.xAxisMinFormattedTextField.setValue(this.chart.getXAxisMin());
            this.xAxisMaxFormattedTextField.setValue(this.chart.getXAxisMax());
            this.xAxisDrawGridCheckBox.setSelected(this.chart.isXAxisDrawGrid());
            this.xAxisLabelsCheckBox.setSelected(this.chart.getXAxisLabels() != null);
            this.xAxisLabelRotationSpinner.setValue(this.chart.getXAxisLabelRotation());
            this.xAxisMinLabel.setEnabled(!this.xAxisAutoCalcCheckBox.isSelected());
            this.xAxisMinFormattedTextField.setEnabled(!this.xAxisAutoCalcCheckBox.isSelected());
            this.xAxisMaxLabel.setEnabled(!this.xAxisAutoCalcCheckBox.isSelected());
            this.xAxisMaxFormattedTextField.setEnabled(!this.xAxisAutoCalcCheckBox.isSelected());
            this.xAxisEditLablesButton.setEnabled(this.xAxisLabelsCheckBox.isSelected());
            this.yAxisTextTextField.setText(this.chart.getYAxisText());
            this.yAxisAutoCalcCheckBox.setSelected(this.chart.isAutoCalcYAxis());
            this.yAxisMinFormattedTextField.setValue(this.chart.getYAxisMin());
            this.yAxisMaxFormattedTextField.setValue(this.chart.getYAxisMax());
            this.yAxisDrawGridCheckBox.setSelected(this.chart.isYAxisDrawGrid());
            this.yAxisLabelsCheckBox.setSelected(this.chart.getYAxisLabels() != null);
            this.yAxisMinLabel.setEnabled(!this.yAxisAutoCalcCheckBox.isSelected());
            this.yAxisMinFormattedTextField.setEnabled(!this.yAxisAutoCalcCheckBox.isSelected());
            this.yAxisMaxLabel.setEnabled(!this.yAxisAutoCalcCheckBox.isSelected());
            this.yAxisMaxFormattedTextField.setEnabled(!this.yAxisAutoCalcCheckBox.isSelected());
            this.yAxisEditLablesButton.setEnabled(this.yAxisLabelsCheckBox.isSelected());
            this.pieAxisTextTextField.setText(this.chart.getPieAxisText());
            this.pieAxisDrawGridCheckBox.setSelected(this.chart.isPieAxisDrawGrid());
            this.pieAxisScaleModeComboBox.setSelectedIndex(this.chart.getPieAxisScaleMode() - 1);
            this.chartAllowZoomingCheckBox.setSelected(this.chart.isAllowZooming());
            this.chartAllowWheelZoomingCheckBox.setSelected(this.chart.isAllowWheelZooming());
            this.chartAllowMovingCheckBox.setSelected(this.chart.isAllowMoving());
        }
    }

    private void seriesToComponents(RswChartSeries s) {
        this.initSeriesPanel = true;
        if (s instanceof RswChartBubbleSeries) {
            this.seriesClassComboBox.setSelectedIndex(5);
            this.seriesNameTextField.setText(s.getName());
            this.seriesColorPanel.setBackground(s.getColor());
            this.seriesShowLabelsCheckBox.setSelected(s.isShowValueLables());
            this.seriesVisibleCheckBox.setSelected(s.isVisible());
            this.seriesAlphaSpinner.setValue(this.alphaToPercent(s.getAlpha()));
            this.seriesDotTypeComboBox.setSelectedIndex(0);
            this.seriesDotTypeLabel.setEnabled(false);
            this.seriesDotTypeComboBox.setEnabled(false);
            this.seriesDrawDotsCheckBox.setSelected(false);
            this.seriesDrawDotsLabel.setEnabled(false);
            this.seriesDrawDotsCheckBox.setEnabled(false);
            this.seriesStrokeWidthSpinner.setValue(1);
            this.seriesStrokeWidthLabel.setEnabled(false);
            this.seriesStrokeWidthSpinner.setEnabled(false);
            RswChartFillSeries fs = (RswChartFillSeries)s;
            if (fs.isGradientFill()) {
                this.seriesGradientFillComboBox.setSelectedIndex(1);
            } else {
                this.seriesGradientFillComboBox.setSelectedIndex(0);
            }
            this.seriesGradientFillLabel.setEnabled(true);
            this.seriesGradientFillComboBox.setEnabled(true);
            this.seriesGradientFillDirectionComboBox.setSelectedIndex(fs.getGradientDirection() - 1);
            this.seriesGradientFillDirectionLabel.setEnabled(fs.isGradientFill());
            this.seriesGradientFillDirectionComboBox.setEnabled(fs.isGradientFill());
            RswChartBubbleSeries bs = (RswChartBubbleSeries)s;
            this.seriesAlwaysCirclesCheckBox.setSelected(bs.getAlwaysCircles());
            this.seriesAlwaysCirclesLabel.setEnabled(true);
            this.seriesAlwaysCirclesCheckBox.setEnabled(true);
        } else if (s instanceof RswChartGanttSeries) {
            this.seriesClassComboBox.setSelectedIndex(4);
            this.seriesNameTextField.setText(s.getName());
            this.seriesColorPanel.setBackground(s.getColor());
            this.seriesShowLabelsCheckBox.setSelected(s.isShowValueLables());
            this.seriesVisibleCheckBox.setSelected(s.isVisible());
            this.seriesAlphaSpinner.setValue(this.alphaToPercent(s.getAlpha()));
            this.seriesDotTypeComboBox.setSelectedIndex(0);
            this.seriesDotTypeLabel.setEnabled(false);
            this.seriesDotTypeComboBox.setEnabled(false);
            this.seriesDrawDotsCheckBox.setSelected(false);
            this.seriesDrawDotsLabel.setEnabled(false);
            this.seriesDrawDotsCheckBox.setEnabled(false);
            this.seriesStrokeWidthSpinner.setValue(1);
            this.seriesStrokeWidthLabel.setEnabled(false);
            this.seriesStrokeWidthSpinner.setEnabled(false);
            RswChartFillSeries fs = (RswChartFillSeries)s;
            if (fs.isGradientFill()) {
                this.seriesGradientFillComboBox.setSelectedIndex(1);
            } else {
                this.seriesGradientFillComboBox.setSelectedIndex(0);
            }
            this.seriesGradientFillLabel.setEnabled(true);
            this.seriesGradientFillComboBox.setEnabled(true);
            this.seriesGradientFillDirectionComboBox.setSelectedIndex(fs.getGradientDirection() - 1);
            this.seriesGradientFillDirectionLabel.setEnabled(fs.isGradientFill());
            this.seriesGradientFillDirectionComboBox.setEnabled(fs.isGradientFill());
            this.seriesAlwaysCirclesCheckBox.setSelected(false);
            this.seriesAlwaysCirclesLabel.setEnabled(false);
            this.seriesAlwaysCirclesCheckBox.setEnabled(false);
        } else if (s instanceof RswChartBarSeries) {
            this.seriesClassComboBox.setSelectedIndex(3);
            this.seriesNameTextField.setText(s.getName());
            this.seriesColorPanel.setBackground(s.getColor());
            this.seriesShowLabelsCheckBox.setSelected(s.isShowValueLables());
            this.seriesVisibleCheckBox.setSelected(s.isVisible());
            this.seriesAlphaSpinner.setValue(this.alphaToPercent(s.getAlpha()));
            this.seriesDotTypeComboBox.setSelectedIndex(0);
            this.seriesDotTypeLabel.setEnabled(false);
            this.seriesDotTypeComboBox.setEnabled(false);
            this.seriesDrawDotsCheckBox.setSelected(false);
            this.seriesDrawDotsLabel.setEnabled(false);
            this.seriesDrawDotsCheckBox.setEnabled(false);
            this.seriesStrokeWidthSpinner.setValue(1);
            this.seriesStrokeWidthLabel.setEnabled(false);
            this.seriesStrokeWidthSpinner.setEnabled(false);
            RswChartFillSeries fs = (RswChartFillSeries)s;
            if (fs.isGradientFill()) {
                this.seriesGradientFillComboBox.setSelectedIndex(1);
            } else {
                this.seriesGradientFillComboBox.setSelectedIndex(0);
            }
            this.seriesGradientFillLabel.setEnabled(true);
            this.seriesGradientFillComboBox.setEnabled(true);
            this.seriesGradientFillDirectionComboBox.setSelectedIndex(fs.getGradientDirection() - 1);
            this.seriesGradientFillDirectionLabel.setEnabled(fs.isGradientFill());
            this.seriesGradientFillDirectionComboBox.setEnabled(fs.isGradientFill());
            this.seriesAlwaysCirclesCheckBox.setSelected(false);
            this.seriesAlwaysCirclesLabel.setEnabled(false);
            this.seriesAlwaysCirclesCheckBox.setEnabled(false);
        } else if (s instanceof RswChartAreaSeries) {
            this.seriesClassComboBox.setSelectedIndex(2);
            this.seriesNameTextField.setText(s.getName());
            this.seriesColorPanel.setBackground(s.getColor());
            this.seriesShowLabelsCheckBox.setSelected(s.isShowValueLables());
            this.seriesVisibleCheckBox.setSelected(s.isVisible());
            this.seriesAlphaSpinner.setValue(this.alphaToPercent(s.getAlpha()));
            this.seriesDotTypeComboBox.setSelectedIndex(0);
            this.seriesDotTypeLabel.setEnabled(false);
            this.seriesDotTypeComboBox.setEnabled(false);
            this.seriesDrawDotsCheckBox.setSelected(false);
            this.seriesDrawDotsLabel.setEnabled(false);
            this.seriesDrawDotsCheckBox.setEnabled(false);
            this.seriesStrokeWidthSpinner.setValue(1);
            this.seriesStrokeWidthLabel.setEnabled(false);
            this.seriesStrokeWidthSpinner.setEnabled(false);
            RswChartFillSeries fs = (RswChartFillSeries)s;
            if (fs.isGradientFill()) {
                this.seriesGradientFillComboBox.setSelectedIndex(1);
            } else {
                this.seriesGradientFillComboBox.setSelectedIndex(0);
            }
            this.seriesGradientFillLabel.setEnabled(true);
            this.seriesGradientFillComboBox.setEnabled(true);
            this.seriesGradientFillDirectionComboBox.setSelectedIndex(fs.getGradientDirection() - 1);
            this.seriesGradientFillDirectionLabel.setEnabled(fs.isGradientFill());
            this.seriesGradientFillDirectionComboBox.setEnabled(fs.isGradientFill());
            this.seriesAlwaysCirclesCheckBox.setSelected(false);
            this.seriesAlwaysCirclesLabel.setEnabled(false);
            this.seriesAlwaysCirclesCheckBox.setEnabled(false);
        } else if (s instanceof RswChartLineSeries) {
            this.seriesClassComboBox.setSelectedIndex(1);
            this.seriesNameTextField.setText(s.getName());
            this.seriesColorPanel.setBackground(s.getColor());
            this.seriesShowLabelsCheckBox.setSelected(s.isShowValueLables());
            this.seriesVisibleCheckBox.setSelected(s.isVisible());
            this.seriesAlphaSpinner.setValue(this.alphaToPercent(s.getAlpha()));
            RswChartLineSeries ls = (RswChartLineSeries)s;
            this.seriesDotTypeComboBox.setSelectedIndex(ls.getDotType() - 1);
            this.seriesDotTypeLabel.setEnabled(true);
            this.seriesDotTypeComboBox.setEnabled(true);
            this.seriesDrawDotsCheckBox.setSelected(ls.getDrawDots());
            this.seriesDrawDotsLabel.setEnabled(true);
            this.seriesDrawDotsCheckBox.setEnabled(true);
            this.seriesStrokeWidthSpinner.setValue((int)ls.getStroke().getLineWidth());
            this.seriesStrokeWidthLabel.setEnabled(true);
            this.seriesStrokeWidthSpinner.setEnabled(true);
            this.seriesGradientFillComboBox.setSelectedIndex(0);
            this.seriesGradientFillLabel.setEnabled(false);
            this.seriesGradientFillComboBox.setEnabled(false);
            this.seriesGradientFillDirectionComboBox.setSelectedIndex(0);
            this.seriesGradientFillDirectionLabel.setEnabled(false);
            this.seriesGradientFillDirectionComboBox.setEnabled(false);
            this.seriesAlwaysCirclesCheckBox.setSelected(false);
            this.seriesAlwaysCirclesLabel.setEnabled(false);
            this.seriesAlwaysCirclesCheckBox.setEnabled(false);
        } else if (s instanceof RswChartDotSeries) {
            this.seriesClassComboBox.setSelectedIndex(0);
            this.seriesNameTextField.setText(s.getName());
            this.seriesColorPanel.setBackground(s.getColor());
            this.seriesShowLabelsCheckBox.setSelected(s.isShowValueLables());
            this.seriesVisibleCheckBox.setSelected(s.isVisible());
            this.seriesAlphaSpinner.setValue(this.alphaToPercent(s.getAlpha()));
            RswChartDotSeries ls = (RswChartDotSeries)s;
            this.seriesDotTypeComboBox.setSelectedIndex(ls.getDotType() - 1);
            this.seriesDotTypeLabel.setEnabled(true);
            this.seriesDotTypeComboBox.setEnabled(true);
            this.seriesDrawDotsCheckBox.setSelected(true);
            this.seriesDrawDotsLabel.setEnabled(false);
            this.seriesDrawDotsCheckBox.setEnabled(false);
            this.seriesStrokeWidthSpinner.setValue(1);
            this.seriesStrokeWidthLabel.setEnabled(false);
            this.seriesStrokeWidthSpinner.setEnabled(false);
            this.seriesGradientFillComboBox.setSelectedIndex(0);
            this.seriesGradientFillLabel.setEnabled(false);
            this.seriesGradientFillComboBox.setEnabled(false);
            this.seriesGradientFillDirectionComboBox.setSelectedIndex(0);
            this.seriesGradientFillDirectionLabel.setEnabled(false);
            this.seriesGradientFillDirectionComboBox.setEnabled(false);
            this.seriesAlwaysCirclesCheckBox.setSelected(false);
            this.seriesAlwaysCirclesLabel.setEnabled(false);
            this.seriesAlwaysCirclesCheckBox.setEnabled(false);
        }
        this.initSeriesPanel = false;
    }

    private void componentsToChart() {
        if (this.chart != null) {
            this.chart.setTitle(this.chartTitleTextField.getText());
            this.chart.setChartMode(this.chartModeComboBox.getSelectedIndex() + 1);
            this.chart.setShowLegend(this.chartShowLegendCheckBox.isSelected());
            this.chart.setAreaMode(this.chartAreaModeComboBox.getSelectedIndex() + 1);
            this.chart.setBarMode(this.chartBarModeComboBox.getSelectedIndex() + 1);
            this.chart.setFillMode(this.chartFillModeComboBox.getSelectedIndex() + 1);
            this.chart.setColor1(this.chartColor1Panel.getBackground());
            this.chart.setColor2(this.chartColor2Panel.getBackground());
            this.chart.setGradientDirection(this.chartGradientFillDirectionComboBox.getSelectedIndex() + 1);
            this.chart.setAntiAliasing(this.chartAntiAliasingCheckBox.isSelected());
            this.chart.setXAxisText(this.xAxisTextTextField.getText());
            this.chart.setAutoCalcXAxis(this.xAxisAutoCalcCheckBox.isSelected());
            this.chart.setXAxisMin(((Number)this.xAxisMinFormattedTextField.getValue()).doubleValue());
            this.chart.setXAxisMax(((Number)this.xAxisMaxFormattedTextField.getValue()).doubleValue());
            this.chart.setXAxisDrawGrid(this.xAxisDrawGridCheckBox.isSelected());
            if (!this.xAxisLabelsCheckBox.isSelected() && this.chart.xAxisLabels != null) {
                this.chart.xAxisLabels.clear();
                this.chart.xAxisLabels = null;
            }
            this.chart.setXAxisLabelRotation(((Number)this.xAxisLabelRotationSpinner.getValue()).doubleValue());
            this.chart.setYAxisText(this.yAxisTextTextField.getText());
            this.chart.setAutoCalcYAxis(this.yAxisAutoCalcCheckBox.isSelected());
            this.chart.setYAxisMin(((Number)this.yAxisMinFormattedTextField.getValue()).doubleValue());
            this.chart.setYAxisMax(((Number)this.yAxisMaxFormattedTextField.getValue()).doubleValue());
            this.chart.setYAxisDrawGrid(this.yAxisDrawGridCheckBox.isSelected());
            if (!this.yAxisLabelsCheckBox.isSelected() && this.chart.yAxisLabels != null) {
                this.chart.yAxisLabels.clear();
                this.chart.yAxisLabels = null;
            }
            this.chart.setPieAxisText(this.pieAxisTextTextField.getText());
            this.chart.setPieAxisScaleMode(this.pieAxisScaleModeComboBox.getSelectedIndex() + 1);
            this.chart.setPieAxisDrawGrid(this.pieAxisDrawGridCheckBox.isSelected());
            this.chart.setAllowWheelZooming(this.chartAllowWheelZoomingCheckBox.isSelected());
            this.chart.setAllowMoving(this.chartAllowMovingCheckBox.isSelected());
        }
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton();
        this.mainPanel = new JPanel();
        this.headlineLabel = new JLabel();
        this.generalPanel = new JPanel();
        this.chartColor1Label = new JLabel();
        this.chartColor1Panel = new JPanel();
        this.chartColor1Button = new JButton();
        this.chartColor2Label = new JLabel();
        this.chartColor2Panel = new JPanel();
        this.chartColor2Button = new JButton();
        this.chartGradientFillDirectionLabel = new JLabel();
        this.chartGradientFillDirectionComboBox = new JComboBox();
        this.chartTitleLabel = new JLabel();
        this.chartTitleTextField = new JTextField();
        this.chartLegendLabel = new JLabel();
        this.chartShowLegendCheckBox = new JCheckBox();
        this.chartFillClientAreaLabel = new JLabel();
        this.chartFillModeComboBox = new JComboBox();
        this.chartAreaModeLabel = new JLabel();
        this.chartAreaModeComboBox = new JComboBox();
        this.chartBarModeLabel = new JLabel();
        this.chartBarModeComboBox = new JComboBox();
        this.chartAntiAliasingLabel = new JLabel();
        this.chartAntiAliasingCheckBox = new JCheckBox();
        this.chartMouseEventsLabel = new JLabel();
        this.chartAllowZoomingCheckBox = new JCheckBox();
        this.chartAllowWheelZoomingCheckBox = new JCheckBox();
        this.chartAllowMovingCheckBox = new JCheckBox();
        this.chartModeLabel = new JLabel();
        this.chartModeComboBox = new JComboBox();
        this.xAxisPanel = new JPanel();
        this.xAxisTextTextField = new JTextField();
        this.xAxisTextLabel = new JLabel();
        this.xAxisWertebereichLabel = new JLabel();
        this.xAxisMinLabel = new JLabel();
        this.xAxisAutoCalcCheckBox = new JCheckBox();
        this.xAxisMinFormattedTextField = new JFormattedTextField(new DecimalFormat("#,##0.00000"));
        this.xAxisMaxLabel = new JLabel();
        this.xAxisMaxFormattedTextField = new JFormattedTextField(new DecimalFormat("#,##0.00000"));
        this.xAxisLabelsLabel = new JLabel();
        this.xAxisLabelsCheckBox = new JCheckBox();
        this.xAxisEditLablesButton = new JButton();
        this.xAxisLabelRotationLabel = new JLabel();
        this.xAxisLabelRotationSpinner = new JSpinner();
        this.xAxisDrawGridLabel = new JLabel();
        this.xAxisDrawGridCheckBox = new JCheckBox();
        this.yAxisPanel = new JPanel();
        this.yAxisTextTextField = new JTextField();
        this.yAxisTextLabel = new JLabel();
        this.yAxisWertebereichLabel = new JLabel();
        this.yAxisMinLabel = new JLabel();
        this.yAxisAutoCalcCheckBox = new JCheckBox();
        this.yAxisMinFormattedTextField = new JFormattedTextField(new DecimalFormat("#,##0.00000"));
        this.yAxisMaxLabel = new JLabel();
        this.yAxisMaxFormattedTextField = new JFormattedTextField(new DecimalFormat("#,##0.00000"));
        this.yAxisLabelsLabel = new JLabel();
        this.yAxisLabelsCheckBox = new JCheckBox();
        this.yAxisEditLablesButton = new JButton();
        this.yAxisDrawGridLabel = new JLabel();
        this.yAxisDrawGridCheckBox = new JCheckBox();
        this.axisPanel = new JPanel();
        this.axisLabel = new JLabel();
        this.seriesListPanel = new JPanel();
        this.seriesListLabel = new JLabel();
        this.seriesPanel = new JPanel();
        this.seriesColorLabel = new JLabel();
        this.seriesColorPanel = new JPanel();
        this.seriesColorButton = new JButton();
        this.seriesGradientFillDirectionLabel = new JLabel();
        this.seriesGradientFillDirectionComboBox = new JComboBox();
        this.seriesNameLabel = new JLabel();
        this.seriesNameTextField = new JTextField();
        this.seriesShowLabelsLabel = new JLabel();
        this.seriesShowLabelsCheckBox = new JCheckBox();
        this.seriesGradientFillLabel = new JLabel();
        this.seriesGradientFillComboBox = new JComboBox();
        this.seriesClassLabel = new JLabel();
        this.seriesClassComboBox = new JComboBox();
        this.seriesDotTypeLabel = new JLabel();
        this.seriesDotTypeComboBox = new JComboBox();
        this.seriesDrawDotsLabel = new JLabel();
        this.seriesDrawDotsCheckBox = new JCheckBox();
        this.seriesStrokeWidthLabel = new JLabel();
        this.seriesStrokeWidthSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 99, 1));
        this.seriesAlwaysCirclesLabel = new JLabel();
        this.seriesAlwaysCirclesCheckBox = new JCheckBox();
        this.seriesVisibleLabel = new JLabel();
        this.seriesVisibleCheckBox = new JCheckBox();
        this.seriesAlphaLabel = new JLabel();
        this.seriesAlphaSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 100, 1));
        this.jLabel1 = new JLabel();
        this.pieAxisPanel = new JPanel();
        this.pieAxisTextTextField = new JTextField();
        this.pieAxisTextLabel = new JLabel();
        this.pieAxisDrawGridLabel = new JLabel();
        this.pieAxisDrawGridCheckBox = new JCheckBox();
        this.pieAxisScaleModeLabel = new JLabel();
        this.pieAxisScaleModeComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.setDefaultCloseOperation(2);
        this.setTitle("Chart bearbeiten");
        this.setResizable(false);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.closeButton.setText("Schlie\u00dfen");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.mainPanel.setLayout(new GridBagLayout());
        this.headlineLabel.setFont(new Font("Dialog", 1, 14));
        this.headlineLabel.setText("Headline");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.mainPanel.add((Component)this.headlineLabel, gridBagConstraints);
        this.generalPanel.setLayout(new GridBagLayout());
        this.generalPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.generalPanel.setMinimumSize(new Dimension(400, 20));
        this.generalPanel.setPreferredSize(new Dimension(400, 20));
        this.chartColor1Label.setText("Farbe 1:");
        this.chartColor1Label.setMinimumSize(new Dimension(115, 16));
        this.chartColor1Label.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartColor1Label, gridBagConstraints);
        this.chartColor1Label.getAccessibleContext().setAccessibleName("VonFarbe:");
        this.chartColor1Panel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.chartColor1Panel.setMinimumSize(new Dimension(70, 25));
        this.chartColor1Panel.setPreferredSize(new Dimension(70, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartColor1Panel, gridBagConstraints);
        this.chartColor1Button.setText("...");
        this.chartColor1Button.setMinimumSize(new Dimension(25, 25));
        this.chartColor1Button.setPreferredSize(new Dimension(25, 25));
        this.chartColor1Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.chartColor1ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.generalPanel.add((Component)this.chartColor1Button, gridBagConstraints);
        this.chartColor2Label.setText("Farbe 2:");
        this.chartColor2Label.setMinimumSize(new Dimension(115, 16));
        this.chartColor2Label.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartColor2Label, gridBagConstraints);
        this.chartColor2Panel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.chartColor2Panel.setMinimumSize(new Dimension(70, 25));
        this.chartColor2Panel.setPreferredSize(new Dimension(70, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartColor2Panel, gridBagConstraints);
        this.chartColor2Button.setText("...");
        this.chartColor2Button.setMinimumSize(new Dimension(25, 25));
        this.chartColor2Button.setPreferredSize(new Dimension(25, 25));
        this.chartColor2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.chartColor2ButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.generalPanel.add((Component)this.chartColor2Button, gridBagConstraints);
        this.chartGradientFillDirectionLabel.setText("Richtung:");
        this.chartGradientFillDirectionLabel.setMinimumSize(new Dimension(115, 16));
        this.chartGradientFillDirectionLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartGradientFillDirectionLabel, gridBagConstraints);
        this.chartGradientFillDirectionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Von Norden nach S\u00fcden", "Von S\u00fcden nach Norden", "Von Westen nach Osten", "Von Osten nach Westen", "Von Nordwesten nach S\u00fcdosten", "Von Nordosten nach S\u00fcdwesten", "Von S\u00fcdwesten nach Nordosten", "Von S\u00fcdosten nach Nordwesten"}));
        this.chartGradientFillDirectionComboBox.setMinimumSize(new Dimension(260, 22));
        this.chartGradientFillDirectionComboBox.setPreferredSize(new Dimension(260, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartGradientFillDirectionComboBox, gridBagConstraints);
        this.chartTitleLabel.setText("Titel:");
        this.chartTitleLabel.setMaximumSize(new Dimension(115, 16));
        this.chartTitleLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.generalPanel.add((Component)this.chartTitleLabel, gridBagConstraints);
        this.chartTitleTextField.setMinimumSize(new Dimension(260, 22));
        this.chartTitleTextField.setPreferredSize(new Dimension(260, 22));
        this.chartTitleTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                RswChartEditorFrame.this.chartTitleTextFieldFocusGained(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.generalPanel.add((Component)this.chartTitleTextField, gridBagConstraints);
        this.chartLegendLabel.setText("Legende:");
        this.chartLegendLabel.setMinimumSize(new Dimension(115, 16));
        this.chartLegendLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartLegendLabel, gridBagConstraints);
        this.chartShowLegendCheckBox.setText("Legend anzeigen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartShowLegendCheckBox, gridBagConstraints);
        this.chartFillClientAreaLabel.setText("Farbe Wertebereich:");
        this.chartFillClientAreaLabel.setMinimumSize(new Dimension(115, 16));
        this.chartFillClientAreaLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartFillClientAreaLabel, gridBagConstraints);
        this.chartFillModeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"nicht f\u00fcllen", "mit Farbe 1 f\u00fcllen", "Farbverlauf"}));
        this.chartFillModeComboBox.setMinimumSize(new Dimension(260, 22));
        this.chartFillModeComboBox.setPreferredSize(new Dimension(260, 22));
        this.chartFillModeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RswChartEditorFrame.this.chartFillModeComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartFillModeComboBox, gridBagConstraints);
        this.chartAreaModeLabel.setText("Fl\u00e4chenserien:");
        this.chartAreaModeLabel.setMinimumSize(new Dimension(115, 16));
        this.chartAreaModeLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartAreaModeLabel, gridBagConstraints);
        this.chartAreaModeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"normal darstellen", "gestapelt darstellen"}));
        this.chartAreaModeComboBox.setMinimumSize(new Dimension(260, 22));
        this.chartAreaModeComboBox.setPreferredSize(new Dimension(260, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartAreaModeComboBox, gridBagConstraints);
        this.chartBarModeLabel.setText("Balkenserien:");
        this.chartBarModeLabel.setMinimumSize(new Dimension(115, 16));
        this.chartBarModeLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartBarModeLabel, gridBagConstraints);
        this.chartBarModeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"normal darstellen", "gestapelt darstellen", "nebeneinander darstellen"}));
        this.chartBarModeComboBox.setMinimumSize(new Dimension(260, 22));
        this.chartBarModeComboBox.setPreferredSize(new Dimension(260, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartBarModeComboBox, gridBagConstraints);
        this.chartAntiAliasingLabel.setText("Weichzeichnen:");
        this.chartAntiAliasingLabel.setMinimumSize(new Dimension(115, 16));
        this.chartAntiAliasingLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartAntiAliasingLabel, gridBagConstraints);
        this.chartAntiAliasingCheckBox.setText("aktiviert");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartAntiAliasingCheckBox, gridBagConstraints);
        this.chartMouseEventsLabel.setText("Mausverhalten:");
        this.chartMouseEventsLabel.setMinimumSize(new Dimension(115, 16));
        this.chartMouseEventsLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartMouseEventsLabel, gridBagConstraints);
        this.chartAllowZoomingCheckBox.setText("Zoom mit linker Maustaste aktivieren");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartAllowZoomingCheckBox, gridBagConstraints);
        this.chartAllowWheelZoomingCheckBox.setText("Zoom mit Mausrad aktivieren");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartAllowWheelZoomingCheckBox, gridBagConstraints);
        this.chartAllowMovingCheckBox.setText("Bewegen mit rechter Maustaste aktivieren");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 26, 10);
        this.generalPanel.add((Component)this.chartAllowMovingCheckBox, gridBagConstraints);
        this.chartModeLabel.setText("Darstellung:");
        this.chartModeLabel.setMinimumSize(new Dimension(115, 16));
        this.chartModeLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.generalPanel.add((Component)this.chartModeLabel, gridBagConstraints);
        this.chartModeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"normal", "als Tortendiagramm (Summe)", "als Tortendiagramm (Durchschnitt)", "als Tortendiagramm (Maximum)"}));
        this.chartModeComboBox.setMinimumSize(new Dimension(260, 22));
        this.chartModeComboBox.setPreferredSize(new Dimension(260, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.generalPanel.add((Component)this.chartModeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 2, 10);
        this.mainPanel.add((Component)this.generalPanel, gridBagConstraints);
        this.xAxisPanel.setLayout(new GridBagLayout());
        this.xAxisPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.xAxisPanel.setMinimumSize(new Dimension(400, 20));
        this.xAxisPanel.setPreferredSize(new Dimension(400, 20));
        this.xAxisTextTextField.setMinimumSize(new Dimension(260, 22));
        this.xAxisTextTextField.setPreferredSize(new Dimension(260, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.xAxisPanel.add((Component)this.xAxisTextTextField, gridBagConstraints);
        this.xAxisTextLabel.setText("Text:");
        this.xAxisTextLabel.setMinimumSize(new Dimension(115, 16));
        this.xAxisTextLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.xAxisPanel.add((Component)this.xAxisTextLabel, gridBagConstraints);
        this.xAxisWertebereichLabel.setText("Wertebereich:");
        this.xAxisWertebereichLabel.setMinimumSize(new Dimension(115, 16));
        this.xAxisWertebereichLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.xAxisPanel.add((Component)this.xAxisWertebereichLabel, gridBagConstraints);
        this.xAxisMinLabel.setText("Min:");
        this.xAxisMinLabel.setMinimumSize(new Dimension(70, 16));
        this.xAxisMinLabel.setPreferredSize(new Dimension(70, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.xAxisPanel.add((Component)this.xAxisMinLabel, gridBagConstraints);
        this.xAxisAutoCalcCheckBox.setText("automatisch ermitteln");
        this.xAxisAutoCalcCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.xAxisAutoCalcCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.xAxisPanel.add((Component)this.xAxisAutoCalcCheckBox, gridBagConstraints);
        this.xAxisMinFormattedTextField.setHorizontalAlignment(4);
        this.xAxisMinFormattedTextField.setMinimumSize(new Dimension(180, 22));
        this.xAxisMinFormattedTextField.setPreferredSize(new Dimension(180, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.xAxisPanel.add((Component)this.xAxisMinFormattedTextField, gridBagConstraints);
        this.xAxisMaxLabel.setText("Max:");
        this.xAxisMaxLabel.setMinimumSize(new Dimension(70, 16));
        this.xAxisMaxLabel.setPreferredSize(new Dimension(70, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.xAxisPanel.add((Component)this.xAxisMaxLabel, gridBagConstraints);
        this.xAxisMaxFormattedTextField.setHorizontalAlignment(4);
        this.xAxisMaxFormattedTextField.setMinimumSize(new Dimension(180, 22));
        this.xAxisMaxFormattedTextField.setPreferredSize(new Dimension(180, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.xAxisPanel.add((Component)this.xAxisMaxFormattedTextField, gridBagConstraints);
        this.xAxisLabelsLabel.setText("Beschriftung:");
        this.xAxisLabelsLabel.setMinimumSize(new Dimension(115, 16));
        this.xAxisLabelsLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.xAxisPanel.add((Component)this.xAxisLabelsLabel, gridBagConstraints);
        this.xAxisLabelsCheckBox.setText("eigene Beschriftung");
        this.xAxisLabelsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.xAxisLabelsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.xAxisPanel.add((Component)this.xAxisLabelsCheckBox, gridBagConstraints);
        this.xAxisEditLablesButton.setText("Bearbeiten...");
        this.xAxisEditLablesButton.setMinimumSize(new Dimension(113, 25));
        this.xAxisEditLablesButton.setPreferredSize(new Dimension(113, 25));
        this.xAxisEditLablesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.xAxisEditLablesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.xAxisPanel.add((Component)this.xAxisEditLablesButton, gridBagConstraints);
        this.xAxisLabelRotationLabel.setText("Drehen um:");
        this.xAxisLabelRotationLabel.setMinimumSize(new Dimension(70, 16));
        this.xAxisLabelRotationLabel.setPreferredSize(new Dimension(70, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 192, 0);
        this.xAxisPanel.add((Component)this.xAxisLabelRotationLabel, gridBagConstraints);
        this.xAxisLabelRotationSpinner.setMinimumSize(new Dimension(180, 22));
        this.xAxisLabelRotationSpinner.setPreferredSize(new Dimension(180, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 192, 10);
        this.xAxisPanel.add((Component)this.xAxisLabelRotationSpinner, gridBagConstraints);
        this.xAxisDrawGridLabel.setText("Gitterlinien:");
        this.xAxisDrawGridLabel.setMinimumSize(new Dimension(115, 16));
        this.xAxisDrawGridLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.xAxisPanel.add((Component)this.xAxisDrawGridLabel, gridBagConstraints);
        this.xAxisDrawGridCheckBox.setText("anzeigen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.xAxisPanel.add((Component)this.xAxisDrawGridCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 2, 10);
        this.mainPanel.add((Component)this.xAxisPanel, gridBagConstraints);
        this.yAxisPanel.setLayout(new GridBagLayout());
        this.yAxisPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.yAxisPanel.setMinimumSize(new Dimension(400, 20));
        this.yAxisPanel.setPreferredSize(new Dimension(400, 20));
        this.yAxisTextTextField.setMinimumSize(new Dimension(260, 22));
        this.yAxisTextTextField.setPreferredSize(new Dimension(260, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.yAxisPanel.add((Component)this.yAxisTextTextField, gridBagConstraints);
        this.yAxisTextLabel.setText("Text:");
        this.yAxisTextLabel.setMinimumSize(new Dimension(115, 16));
        this.yAxisTextLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.yAxisPanel.add((Component)this.yAxisTextLabel, gridBagConstraints);
        this.yAxisWertebereichLabel.setText("Wertebereich:");
        this.yAxisWertebereichLabel.setMinimumSize(new Dimension(115, 16));
        this.yAxisWertebereichLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.yAxisPanel.add((Component)this.yAxisWertebereichLabel, gridBagConstraints);
        this.yAxisMinLabel.setText("Min:");
        this.yAxisMinLabel.setMinimumSize(new Dimension(70, 16));
        this.yAxisMinLabel.setPreferredSize(new Dimension(70, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.yAxisPanel.add((Component)this.yAxisMinLabel, gridBagConstraints);
        this.yAxisAutoCalcCheckBox.setText("automatisch ermitteln");
        this.yAxisAutoCalcCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.yAxisAutoCalcCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.yAxisPanel.add((Component)this.yAxisAutoCalcCheckBox, gridBagConstraints);
        this.yAxisMinFormattedTextField.setHorizontalAlignment(4);
        this.yAxisMinFormattedTextField.setMinimumSize(new Dimension(180, 22));
        this.yAxisMinFormattedTextField.setPreferredSize(new Dimension(180, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.yAxisPanel.add((Component)this.yAxisMinFormattedTextField, gridBagConstraints);
        this.yAxisMaxLabel.setText("Max:");
        this.yAxisMaxLabel.setMinimumSize(new Dimension(70, 16));
        this.yAxisMaxLabel.setPreferredSize(new Dimension(70, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.yAxisPanel.add((Component)this.yAxisMaxLabel, gridBagConstraints);
        this.yAxisMaxFormattedTextField.setHorizontalAlignment(4);
        this.yAxisMaxFormattedTextField.setMinimumSize(new Dimension(180, 22));
        this.yAxisMaxFormattedTextField.setPreferredSize(new Dimension(180, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.yAxisPanel.add((Component)this.yAxisMaxFormattedTextField, gridBagConstraints);
        this.yAxisLabelsLabel.setText("Beschriftung:");
        this.yAxisLabelsLabel.setMinimumSize(new Dimension(115, 16));
        this.yAxisLabelsLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 219, 0);
        this.yAxisPanel.add((Component)this.yAxisLabelsLabel, gridBagConstraints);
        this.yAxisLabelsCheckBox.setText("eigene Beschriftung");
        this.yAxisLabelsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.yAxisLabelsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 219, 10);
        this.yAxisPanel.add((Component)this.yAxisLabelsCheckBox, gridBagConstraints);
        this.yAxisEditLablesButton.setText("Bearbeiten...");
        this.yAxisEditLablesButton.setMinimumSize(new Dimension(113, 25));
        this.yAxisEditLablesButton.setPreferredSize(new Dimension(113, 25));
        this.yAxisEditLablesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.yAxisEditLablesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 10, 219, 10);
        this.yAxisPanel.add((Component)this.yAxisEditLablesButton, gridBagConstraints);
        this.yAxisDrawGridLabel.setText("Gitterlinien:");
        this.yAxisDrawGridLabel.setMinimumSize(new Dimension(115, 16));
        this.yAxisDrawGridLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.yAxisPanel.add((Component)this.yAxisDrawGridLabel, gridBagConstraints);
        this.yAxisDrawGridCheckBox.setText("anzeigen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.yAxisPanel.add((Component)this.yAxisDrawGridCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 2, 10);
        this.mainPanel.add((Component)this.yAxisPanel, gridBagConstraints);
        this.axisPanel.setLayout(new GridBagLayout());
        this.axisPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.axisPanel.setMinimumSize(new Dimension(400, 20));
        this.axisPanel.setPreferredSize(new Dimension(400, 20));
        this.axisLabel.setText("W\u00e4hlen Sie eine der Achsen im Baumdiagramm links aus.");
        this.axisLabel.setMaximumSize(new Dimension(370, 16));
        this.axisLabel.setMinimumSize(new Dimension(370, 16));
        this.axisLabel.setPreferredSize(new Dimension(370, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 374, 10);
        this.axisPanel.add((Component)this.axisLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 2, 10);
        this.mainPanel.add((Component)this.axisPanel, gridBagConstraints);
        this.seriesListPanel.setLayout(new GridBagLayout());
        this.seriesListPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.seriesListPanel.setMinimumSize(new Dimension(400, 20));
        this.seriesListPanel.setPreferredSize(new Dimension(400, 20));
        this.seriesListLabel.setText("W\u00e4hlen Sie eine der Seiren im Baumdiagramm links aus.");
        this.seriesListLabel.setMaximumSize(new Dimension(370, 16));
        this.seriesListLabel.setMinimumSize(new Dimension(370, 16));
        this.seriesListLabel.setPreferredSize(new Dimension(370, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 374, 10);
        this.seriesListPanel.add((Component)this.seriesListLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 2, 10);
        this.mainPanel.add((Component)this.seriesListPanel, gridBagConstraints);
        this.seriesPanel.setLayout(new GridBagLayout());
        this.seriesPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.seriesPanel.setMinimumSize(new Dimension(400, 20));
        this.seriesPanel.setPreferredSize(new Dimension(400, 20));
        this.seriesColorLabel.setText("Farbe:");
        this.seriesColorLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesColorLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesColorLabel, gridBagConstraints);
        this.seriesColorPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.seriesColorPanel.setMinimumSize(new Dimension(70, 25));
        this.seriesColorPanel.setPreferredSize(new Dimension(70, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesColorPanel, gridBagConstraints);
        this.seriesColorButton.setText("...");
        this.seriesColorButton.setMinimumSize(new Dimension(25, 25));
        this.seriesColorButton.setPreferredSize(new Dimension(25, 25));
        this.seriesColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.seriesColorButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.seriesPanel.add((Component)this.seriesColorButton, gridBagConstraints);
        this.seriesGradientFillDirectionLabel.setText("Richtung:");
        this.seriesGradientFillDirectionLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesGradientFillDirectionLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesGradientFillDirectionLabel, gridBagConstraints);
        this.seriesGradientFillDirectionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Von Norden nach S\u00fcden", "Von S\u00fcden nach Norden", "Von Westen nach Osten", "Von Osten nach Westen", "Von Nordwesten nach S\u00fcdosten", "Von Nordosten nach S\u00fcdwesten", "Von S\u00fcdwesten nach Nordosten", "Von S\u00fcdosten nach Nordwesten"}));
        this.seriesGradientFillDirectionComboBox.setMinimumSize(new Dimension(260, 22));
        this.seriesGradientFillDirectionComboBox.setPreferredSize(new Dimension(260, 22));
        this.seriesGradientFillDirectionComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RswChartEditorFrame.this.seriesGradientFillDirectionComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesGradientFillDirectionComboBox, gridBagConstraints);
        this.seriesNameLabel.setText("Name:");
        this.seriesNameLabel.setMaximumSize(new Dimension(115, 16));
        this.seriesNameLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesNameLabel, gridBagConstraints);
        this.seriesNameTextField.setMinimumSize(new Dimension(260, 22));
        this.seriesNameTextField.setPreferredSize(new Dimension(260, 22));
        this.seriesNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                RswChartEditorFrame.this.seriesNameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesNameTextField, gridBagConstraints);
        this.seriesShowLabelsLabel.setText("Beschriftung:");
        this.seriesShowLabelsLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesShowLabelsLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesShowLabelsLabel, gridBagConstraints);
        this.seriesShowLabelsCheckBox.setText("pro Wert anzeigen");
        this.seriesShowLabelsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.seriesShowLabelsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesShowLabelsCheckBox, gridBagConstraints);
        this.seriesGradientFillLabel.setText("Farbe Wertebereich:");
        this.seriesGradientFillLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesGradientFillLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesGradientFillLabel, gridBagConstraints);
        this.seriesGradientFillComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"einfach f\u00fcllen", "Farbverlauf"}));
        this.seriesGradientFillComboBox.setMinimumSize(new Dimension(260, 22));
        this.seriesGradientFillComboBox.setPreferredSize(new Dimension(260, 22));
        this.seriesGradientFillComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RswChartEditorFrame.this.seriesGradientFillComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesGradientFillComboBox, gridBagConstraints);
        this.seriesClassLabel.setText("Serientyp:");
        this.seriesClassLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesClassLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesClassLabel, gridBagConstraints);
        this.seriesClassComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Punkte", "Linie", "Fl\u00e4che", "Balken", "Gantt", "Blasen"}));
        this.seriesClassComboBox.setMinimumSize(new Dimension(260, 22));
        this.seriesClassComboBox.setPreferredSize(new Dimension(260, 22));
        this.seriesClassComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RswChartEditorFrame.this.seriesClassComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesClassComboBox, gridBagConstraints);
        this.seriesDotTypeLabel.setText("Punkttyp:");
        this.seriesDotTypeLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesDotTypeLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesDotTypeLabel, gridBagConstraints);
        this.seriesDotTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Kreise", "Quadrate", "Rauten", "Sterne"}));
        this.seriesDotTypeComboBox.setMinimumSize(new Dimension(260, 22));
        this.seriesDotTypeComboBox.setPreferredSize(new Dimension(260, 22));
        this.seriesDotTypeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                RswChartEditorFrame.this.seriesDotTypeComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesDotTypeComboBox, gridBagConstraints);
        this.seriesDrawDotsLabel.setText("Punkte bei Linien:");
        this.seriesDrawDotsLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesDrawDotsLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesDrawDotsLabel, gridBagConstraints);
        this.seriesDrawDotsCheckBox.setText("Punkte anzeigen");
        this.seriesDrawDotsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.seriesDrawDotsCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesDrawDotsCheckBox, gridBagConstraints);
        this.seriesStrokeWidthLabel.setText("Liniendicke:");
        this.seriesStrokeWidthLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesStrokeWidthLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesStrokeWidthLabel, gridBagConstraints);
        this.seriesStrokeWidthSpinner.setMinimumSize(new Dimension(70, 22));
        this.seriesStrokeWidthSpinner.setPreferredSize(new Dimension(70, 22));
        this.seriesStrokeWidthSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RswChartEditorFrame.this.seriesStrokeWidthSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesStrokeWidthSpinner, gridBagConstraints);
        this.seriesAlwaysCirclesLabel.setText("Blasenwerte:");
        this.seriesAlwaysCirclesLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesAlwaysCirclesLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 56, 0);
        this.seriesPanel.add((Component)this.seriesAlwaysCirclesLabel, gridBagConstraints);
        this.seriesAlwaysCirclesCheckBox.setText("immer kreisf\u00f6rmig anzeigen");
        this.seriesAlwaysCirclesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.seriesAlwaysCirclesCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 56, 10);
        this.seriesPanel.add((Component)this.seriesAlwaysCirclesCheckBox, gridBagConstraints);
        this.seriesVisibleLabel.setText("Sichtbar:");
        this.seriesVisibleLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesVisibleLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesVisibleLabel, gridBagConstraints);
        this.seriesVisibleCheckBox.setText("ja");
        this.seriesVisibleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartEditorFrame.this.seriesVisibleCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesVisibleCheckBox, gridBagConstraints);
        this.seriesAlphaLabel.setText("Farbtransparenz:");
        this.seriesAlphaLabel.setMinimumSize(new Dimension(115, 16));
        this.seriesAlphaLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.seriesPanel.add((Component)this.seriesAlphaLabel, gridBagConstraints);
        this.seriesAlphaSpinner.setMinimumSize(new Dimension(70, 22));
        this.seriesAlphaSpinner.setPreferredSize(new Dimension(70, 22));
        this.seriesAlphaSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                RswChartEditorFrame.this.seriesAlphaSpinnerStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.seriesPanel.add((Component)this.seriesAlphaSpinner, gridBagConstraints);
        this.jLabel1.setText("Prozent");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        this.seriesPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 2, 10);
        this.mainPanel.add((Component)this.seriesPanel, gridBagConstraints);
        this.pieAxisPanel.setLayout(new GridBagLayout());
        this.pieAxisPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.pieAxisPanel.setMinimumSize(new Dimension(400, 400));
        this.pieAxisPanel.setPreferredSize(new Dimension(400, 400));
        this.pieAxisTextTextField.setMinimumSize(new Dimension(260, 22));
        this.pieAxisTextTextField.setPreferredSize(new Dimension(260, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.pieAxisPanel.add((Component)this.pieAxisTextTextField, gridBagConstraints);
        this.pieAxisTextLabel.setText("Text:");
        this.pieAxisTextLabel.setMinimumSize(new Dimension(115, 16));
        this.pieAxisTextLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.pieAxisPanel.add((Component)this.pieAxisTextLabel, gridBagConstraints);
        this.pieAxisDrawGridLabel.setText("Gitterlinien:");
        this.pieAxisDrawGridLabel.setMinimumSize(new Dimension(115, 16));
        this.pieAxisDrawGridLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 304, 0);
        this.pieAxisPanel.add((Component)this.pieAxisDrawGridLabel, gridBagConstraints);
        this.pieAxisDrawGridCheckBox.setText("anzeigen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 304, 10);
        this.pieAxisPanel.add((Component)this.pieAxisDrawGridCheckBox, gridBagConstraints);
        this.pieAxisScaleModeLabel.setText("Skalierung:");
        this.pieAxisScaleModeLabel.setMinimumSize(new Dimension(115, 16));
        this.pieAxisScaleModeLabel.setPreferredSize(new Dimension(115, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.pieAxisPanel.add((Component)this.pieAxisScaleModeLabel, gridBagConstraints);
        this.pieAxisScaleModeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"absolute Werte", "5-Prozent-Schritte", "10-Prozent-Schritte", "25-Prozent-Schritte"}));
        this.pieAxisScaleModeComboBox.setMinimumSize(new Dimension(260, 22));
        this.pieAxisScaleModeComboBox.setPreferredSize(new Dimension(260, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.pieAxisPanel.add((Component)this.pieAxisScaleModeComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 2, 10);
        this.mainPanel.add((Component)this.pieAxisPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.jScrollPane1.setMinimumSize(new Dimension(150, 24));
        this.jScrollPane1.setPreferredSize(new Dimension(150, 324));
        this.tree.setRootVisible(false);
        this.jScrollPane1.setViewportView(this.tree);
        this.getContentPane().add((Component)this.jScrollPane1, "West");
        this.pack();
    }

    private void seriesAlphaSpinnerStateChanged(ChangeEvent evt) {
        int i = ((SpinnerNumberModel)this.seriesAlphaSpinner.getModel()).getNumber().intValue();
        this.selectedSeries.setAlpha(this.percentToAlpha(i));
    }

    private void seriesVisibleCheckBoxActionPerformed(ActionEvent evt) {
        this.selectedSeries.setVisible(this.seriesVisibleCheckBox.isSelected());
    }

    private void seriesAlwaysCirclesCheckBoxActionPerformed(ActionEvent evt) {
        if (this.selectedSeries instanceof RswChartBubbleSeries) {
            ((RswChartBubbleSeries)this.selectedSeries).setAlwaysCircles(this.seriesAlwaysCirclesCheckBox.isSelected());
        }
    }

    private void yAxisEditLablesButtonActionPerformed(ActionEvent evt) {
        if (this.chart.yAxisLabels == null) {
            this.chart.yAxisLabels = new ArrayList();
        }
        RswChartAxisLabelEditorFrame f = new RswChartAxisLabelEditorFrame(this.chart.yAxisLabels, this, true);
        f.setVisible(true);
        if (this.chart.yAxisLabels == null || this.chart.yAxisLabels.size() == 0) {
            this.yAxisLabelsCheckBox.setSelected(false);
        }
    }

    private void xAxisEditLablesButtonActionPerformed(ActionEvent evt) {
        if (this.chart.xAxisLabels == null) {
            this.chart.xAxisLabels = new ArrayList();
        }
        RswChartAxisLabelEditorFrame f = new RswChartAxisLabelEditorFrame(this.chart.xAxisLabels, this, true);
        f.setVisible(true);
        if (this.chart.xAxisLabels == null || this.chart.xAxisLabels.size() == 0) {
            this.xAxisLabelsCheckBox.setSelected(false);
        }
    }

    private void seriesClassComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.initSeriesPanel) {
            int i = this.seriesClassComboBox.getSelectedIndex();
            RswChartSeries tmp = null;
            switch (i) {
                case 0: {
                    tmp = new RswChartDotSeries(this.selectedSeries);
                    break;
                }
                case 1: {
                    tmp = new RswChartLineSeries(this.selectedSeries);
                    break;
                }
                case 2: {
                    tmp = new RswChartAreaSeries(this.selectedSeries);
                    break;
                }
                case 3: {
                    tmp = new RswChartBarSeries(this.selectedSeries);
                    break;
                }
                case 4: {
                    tmp = new RswChartGanttSeries(this.selectedSeries);
                    break;
                }
                case 5: {
                    tmp = new RswChartBubbleSeries(this.selectedSeries);
                }
            }
            this.chart.seriesList.add(this.chart.seriesList.indexOf(this.selectedSeries), tmp);
            this.chart.removeSeries(this.selectedSeries);
            this.selectedSeries = tmp;
            this.seriesToComponents(this.selectedSeries);
        }
    }

    private void seriesGradientFillDirectionComboBoxItemStateChanged(ItemEvent evt) {
        if (this.selectedSeries instanceof RswChartFillSeries) {
            ((RswChartFillSeries)this.selectedSeries).setGradientDirection(this.seriesGradientFillDirectionComboBox.getSelectedIndex() + 1);
        }
    }

    private void seriesGradientFillComboBoxItemStateChanged(ItemEvent evt) {
        if (this.selectedSeries instanceof RswChartFillSeries) {
            ((RswChartFillSeries)this.selectedSeries).setGradientFill(this.seriesGradientFillComboBox.getSelectedIndex() == 1);
        }
        this.seriesGradientFillDirectionLabel.setEnabled(this.seriesGradientFillComboBox.getSelectedIndex() == 1);
        this.seriesGradientFillDirectionComboBox.setEnabled(this.seriesGradientFillComboBox.getSelectedIndex() == 1);
    }

    private void seriesStrokeWidthSpinnerStateChanged(ChangeEvent evt) {
        if (this.selectedSeries instanceof RswChartLineSeries) {
            int i = ((SpinnerNumberModel)this.seriesStrokeWidthSpinner.getModel()).getNumber().intValue();
            ((RswChartLineSeries)this.selectedSeries).setStroke(new BasicStroke(i));
        }
    }

    private void seriesDrawDotsCheckBoxActionPerformed(ActionEvent evt) {
        if (this.selectedSeries instanceof RswChartLineSeries) {
            ((RswChartLineSeries)this.selectedSeries).setDrawDots(this.seriesDrawDotsCheckBox.isSelected());
        }
    }

    private void seriesDotTypeComboBoxItemStateChanged(ItemEvent evt) {
        if (this.selectedSeries instanceof RswChartDotSeries) {
            ((RswChartDotSeries)this.selectedSeries).setDotType(this.seriesDotTypeComboBox.getSelectedIndex() + 1);
        }
    }

    private void seriesShowLabelsCheckBoxActionPerformed(ActionEvent evt) {
        this.selectedSeries.setShowValueLabels(this.seriesShowLabelsCheckBox.isSelected());
    }

    private void seriesNameTextFieldFocusLost(FocusEvent evt) {
        this.selectedSeries.setName(this.seriesNameTextField.getText());
    }

    private void seriesColorButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Farbe ausw\u00e4hlen", this.seriesColorPanel.getBackground());
        if (newColor != null) {
            this.seriesColorPanel.setBackground(newColor);
            this.selectedSeries.setColor(newColor);
        }
    }

    private void yAxisLabelsCheckBoxActionPerformed(ActionEvent evt) {
        this.yAxisEditLablesButton.setEnabled(this.yAxisLabelsCheckBox.isSelected());
    }

    private void yAxisAutoCalcCheckBoxActionPerformed(ActionEvent evt) {
        this.yAxisMinLabel.setEnabled(!this.yAxisAutoCalcCheckBox.isSelected());
        this.yAxisMinFormattedTextField.setEnabled(!this.yAxisAutoCalcCheckBox.isSelected());
        this.yAxisMaxLabel.setEnabled(!this.yAxisAutoCalcCheckBox.isSelected());
        this.yAxisMaxFormattedTextField.setEnabled(!this.yAxisAutoCalcCheckBox.isSelected());
    }

    private void chartTitleTextFieldFocusGained(FocusEvent evt) {
    }

    private void xAxisLabelsCheckBoxActionPerformed(ActionEvent evt) {
        this.xAxisEditLablesButton.setEnabled(this.xAxisLabelsCheckBox.isSelected());
    }

    private void xAxisAutoCalcCheckBoxActionPerformed(ActionEvent evt) {
        this.xAxisMinLabel.setEnabled(!this.xAxisAutoCalcCheckBox.isSelected());
        this.xAxisMinFormattedTextField.setEnabled(!this.xAxisAutoCalcCheckBox.isSelected());
        this.xAxisMaxLabel.setEnabled(!this.xAxisAutoCalcCheckBox.isSelected());
        this.xAxisMaxFormattedTextField.setEnabled(!this.xAxisAutoCalcCheckBox.isSelected());
    }

    private void chartFillModeComboBoxItemStateChanged(ItemEvent evt) {
        int fm = this.chartFillModeComboBox.getSelectedIndex() + 1;
        boolean enableColor1 = fm == 2 || fm == 3;
        boolean enableColor2 = fm == 3;
        this.chartColor1Label.setEnabled(enableColor1);
        this.chartColor1Panel.setEnabled(enableColor1);
        this.chartColor1Button.setEnabled(enableColor1);
        this.chartColor2Label.setEnabled(enableColor2);
        this.chartColor2Panel.setEnabled(enableColor2);
        this.chartColor2Button.setEnabled(enableColor2);
        this.chartGradientFillDirectionLabel.setEnabled(enableColor2);
        this.chartGradientFillDirectionComboBox.setEnabled(enableColor2);
    }

    private void chartColor2ButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Farbe ausw\u00e4hlen", this.chartColor2Panel.getBackground());
        if (newColor != null) {
            this.chartColor2Panel.setBackground(newColor);
        }
    }

    private void chartColor1ButtonActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Farbe ausw\u00e4hlen", this.chartColor1Panel.getBackground());
        if (newColor != null) {
            this.chartColor1Panel.setBackground(newColor);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.componentsToChart();
        this.setVisible(false);
    }
}

