/*
 * Decompiled with CFR 0.152.
 */
package rsw.chart;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import rsw.chart.RswChartAxisLabel;

public class RswChartAxisLabelEditorFrame
extends JDialog {
    private List labels = null;
    private JButton addButton;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton deleteButton;
    private JButton okButton;
    private JScrollPane scrollPane;
    private JTable table;

    public RswChartAxisLabelEditorFrame(List aLabels, Dialog owner, boolean modal) {
        super(owner, modal);
        this.initComponents();
        this.labels = aLabels;
        ListIterator it = this.labels.listIterator();
        int row = 0;
        DefaultTableModel tm = (DefaultTableModel)this.table.getModel();
        tm.setRowCount(this.labels.size());
        while (it.hasNext()) {
            RswChartAxisLabel l = (RswChartAxisLabel)it.next();
            tm.setValueAt(l.getP(), row, 0);
            tm.setValueAt(l.getLabel(), row, 1);
            ++row;
        }
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(this.table.getSize().width - 50);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        this.setLocation(new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2));
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.setDefaultCloseOperation(2);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.addButton.setText("Hinzuf\u00fcgen");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartAxisLabelEditorFrame.this.addButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.addButton);
        this.deleteButton.setText("L\u00f6schen");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartAxisLabelEditorFrame.this.deleteButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.deleteButton);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartAxisLabelEditorFrame.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Abbrechen");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RswChartAxisLabelEditorFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Position", "Beschriftung"}){
            Class[] types;
            {
                this.types = new Class[]{Double.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.scrollPane.setViewportView(this.table);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel tm = (DefaultTableModel)this.table.getModel();
        int i = this.table.getSelectedRow();
        while (i >= 0) {
            tm.removeRow(i);
            i = this.table.getSelectedRow();
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel tm = (DefaultTableModel)this.table.getModel();
        Vector<Object> v = new Vector<Object>();
        v.add(0.0);
        v.add("");
        tm.addRow(v);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel tm = (DefaultTableModel)this.table.getModel();
        this.labels.clear();
        for (int i = 0; i < tm.getRowCount(); ++i) {
            this.labels.add(new RswChartAxisLabel((Double)tm.getValueAt(i, 0), (String)tm.getValueAt(i, 1)));
        }
        Collections.sort(this.labels);
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

