/*
 * Decompiled with CFR 0.152.
 */
package rsw.chart;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import rsw.chart.RswChartAreaSeries;
import rsw.chart.RswChartAxisLabel;
import rsw.chart.RswChartAxisScale;
import rsw.chart.RswChartBarSeries;
import rsw.chart.RswChartBubbleSeries;
import rsw.chart.RswChartColor;
import rsw.chart.RswChartDotSeries;
import rsw.chart.RswChartEditable;
import rsw.chart.RswChartEditorFrame;
import rsw.chart.RswChartFillSeries;
import rsw.chart.RswChartGanttSeries;
import rsw.chart.RswChartLineSeries;
import rsw.chart.RswChartSeries;
import rsw.chart.RswChartStackableSeries;
import rsw.chart.RswChartValue;
import rsw.chart.RswChartValuesRect;

public class RswChart
extends Component
implements RswChartEditable {
    private static final String version = "0.2.0.0";
    public static final int BAR_MODE_NONE = 1;
    public static final int BAR_MODE_STACKED = 2;
    public static final int BAR_MODE_SIDE = 3;
    public static final int AREA_MODE_NONE = 1;
    public static final int AREA_MODE_STACKED = 2;
    public static final int FILL_MODE_NONE = 1;
    public static final int FILL_MODE_PLAIN = 2;
    public static final int FILL_MODE_GRADIENT = 3;
    public static final int GRADIENT_DIRECTION_NORTH_TO_SOUTH = 1;
    public static final int GRADIENT_DIRECTION_SOUTH_TO_NORTH = 2;
    public static final int GRADIENT_DIRECTION_WEST_TO_EAST = 3;
    public static final int GRADIENT_DIRECTION_EAST_TO_WEST = 4;
    public static final int GRADIENT_DIRECTION_NORTHWEST_TO_SOUTHEAST = 5;
    public static final int GRADIENT_DIRECTION_NORTHEAST_TO_SOUTHWEST = 6;
    public static final int GRADIENT_DIRECTION_SOUTHWEST_TO_NORTHEAST = 7;
    public static final int GRADIENT_DIRECTION_SOUTHEAST_TO_NORTHWEST = 8;
    public static final int CHART_MODE_NORMAL = 1;
    public static final int CHART_MODE_PIE_SUM = 2;
    public static final int CHART_MODE_PIE_AVG = 3;
    public static final int CHART_MODE_PIE_MAX = 4;
    public static final int PIE_AXIS_SCALE_VALUES = 1;
    public static final int PIE_AXIS_SCALE_PERCENT_5 = 2;
    public static final int PIE_AXIS_SCALE_PERCENT_10 = 3;
    public static final int PIE_AXIS_SCALE_PERCENT_25 = 4;
    List seriesList = new ArrayList();
    String title = "Titel";
    private int chartMode = 1;
    private String pieAxisText = "Torten-Achse";
    private double pieAxisMin = 0.0;
    private double pieAxisMax = 0.0;
    private boolean pieAxisDrawGrid = true;
    private int pieAxisScaleMode = 2;
    String xAxisText = "X-Achse";
    boolean autoCalcXAxis = true;
    double xAxisMin = 0.0;
    double xAxisViewMin = 0.0;
    double xAxisMax = 0.0;
    double xAxisViewMax = 0.0;
    boolean xAxisDrawGrid = true;
    List xAxisLabels = null;
    double xAxisLabelRotation = 0.0;
    String yAxisText = "Y-Achse";
    boolean autoCalcYAxis = true;
    double yAxisMin = 0.0;
    double yAxisViewMin = 0.0;
    double yAxisMax = 0.0;
    double yAxisViewMax = 0.0;
    boolean yAxisDrawGrid = true;
    List yAxisLabels = null;
    private boolean showLegend = true;
    private int fillMode = 1;
    private Color color1 = Color.GRAY;
    private Color color2 = Color.WHITE;
    private int gradientDirection = 1;
    private int barMode = 1;
    private int areaMode = 1;
    private Font titleFont = new Font("Arial", 1, 16);
    private Font axisFont = new Font("Arial", 1, 12);
    private Font labelFont = new Font("Arial", 0, 10);
    private Font legendFont = new Font("Arial", 0, 10);
    private float[] gridLinesDash = new float[]{1.0f, 2.0f};
    private float[] selectZoomDash = new float[]{1.0f, 3.0f};
    private boolean antiAliasing = true;
    private Rectangle titleRect = null;
    private Rectangle legendRect = null;
    private Rectangle xAxisRect = null;
    private Rectangle yAxisRect = null;
    private Rectangle clientRect = null;
    private Point xlabelOffSet = null;
    private Point ylabelOffSet = null;
    private RswChartValue zoomVal = null;
    private RswChartValue zoomVal0 = null;
    private Rectangle selectedZoomRect = null;
    private boolean selectingZoom = false;
    private boolean zoomed = false;
    private boolean moving = false;
    private RswChartValue moveVal = null;
    private boolean allowZooming = true;
    private boolean allowWheelZooming = true;
    private boolean allowMoving = true;

    public RswChart() {
        this.setPreferredSize(new Dimension(640, 480));
        this.addMouseEvents();
    }

    public RswChart(Dimension size) {
        if (size == null) {
            size = new Dimension(640, 480);
        }
        this.setPreferredSize(size);
        this.addMouseEvents();
    }

    public static String getVersion() {
        return version;
    }

    private void addMouseEvents() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                Point p;
                if (RswChart.this.selectingZoom && RswChart.this.selectedZoomRect != null) {
                    Point p2;
                    if (RswChart.this.allowZooming && RswChart.this.pointInRect(p2 = evt.getPoint(), RswChart.this.clientRect)) {
                        Point p0 = RswChart.this.getDrawPoint(RswChart.this.zoomVal.getX(), RswChart.this.zoomVal.getY(), RswChart.this.clientRect);
                        if (p2.x < p0.x) {
                            ((RswChart)RswChart.this).selectedZoomRect.x = p2.x;
                            ((RswChart)RswChart.this).selectedZoomRect.width = p0.x - p2.x;
                        } else {
                            ((RswChart)RswChart.this).selectedZoomRect.x = p0.x;
                            ((RswChart)RswChart.this).selectedZoomRect.width = p2.x - p0.x;
                        }
                        if (p2.y < p0.y) {
                            ((RswChart)RswChart.this).selectedZoomRect.y = p2.y;
                            ((RswChart)RswChart.this).selectedZoomRect.height = p0.y - p2.y;
                        } else {
                            ((RswChart)RswChart.this).selectedZoomRect.y = p0.y;
                            ((RswChart)RswChart.this).selectedZoomRect.height = p2.y - p0.y;
                        }
                        RswChart.this.repaint(((RswChart)RswChart.this).clientRect.x, ((RswChart)RswChart.this).clientRect.y, ((RswChart)RswChart.this).clientRect.width, ((RswChart)RswChart.this).clientRect.height);
                    }
                } else if (RswChart.this.moving && RswChart.this.moveVal != null && RswChart.this.allowMoving && RswChart.this.pointInRect(p = evt.getPoint(), RswChart.this.clientRect)) {
                    RswChartValue tmp = RswChart.this.getValueAt(p.x, p.y, RswChart.this.clientRect);
                    RswChart.this.doMove(tmp);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() < 2) {
                    if (RswChart.this.allowZooming) {
                        Point p = evt.getPoint();
                        if (RswChart.this.pointInRect(p, RswChart.this.clientRect)) {
                            RswChart.this.zoomVal = RswChart.this.getValueAt(p.x, p.y, RswChart.this.clientRect);
                            RswChart.this.selectingZoom = true;
                            if (RswChart.this.selectedZoomRect == null) {
                                RswChart.this.selectedZoomRect = new Rectangle(p.x, p.y, 0, 0);
                            }
                        } else {
                            RswChart.this.zoomVal = null;
                        }
                    }
                } else if (evt.getButton() == 3 && evt.getClickCount() < 2 && RswChart.this.allowMoving) {
                    Point p = evt.getPoint();
                    if (RswChart.this.pointInRect(p, RswChart.this.clientRect)) {
                        RswChart.this.moveVal = RswChart.this.getValueAt(p.x, p.y, RswChart.this.clientRect);
                        RswChart.this.moving = true;
                    } else {
                        RswChart.this.moveVal = null;
                    }
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() < 2) {
                    if (RswChart.this.allowZooming) {
                        Point p = evt.getPoint();
                        if (RswChart.this.pointInRect(p, RswChart.this.clientRect)) {
                            RswChart.this.zoomVal0 = RswChart.this.getValueAt(p.x, p.y, RswChart.this.clientRect);
                        } else {
                            RswChart.this.zoomVal0 = null;
                        }
                        RswChart.this.selectedZoomRect = null;
                        if (RswChart.this.zoomVal != null && RswChart.this.zoomVal0 != null) {
                            RswChart.this.doZoom(RswChart.this.zoomVal, RswChart.this.zoomVal0);
                            RswChart.this.selectingZoom = false;
                        } else {
                            RswChart.this.selectingZoom = false;
                            RswChart.this.repaint();
                        }
                    }
                } else if (evt.getButton() == 3 && evt.getClickCount() < 2 && RswChart.this.allowMoving) {
                    RswChart.this.moveVal = null;
                    RswChart.this.moving = false;
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent evt) {
                Point p;
                if (RswChart.this.allowWheelZooming && RswChart.this.pointInRect(p = evt.getPoint(), RswChart.this.clientRect)) {
                    RswChart.this.doZoomInc(evt.getWheelRotation(), p, RswChart.this.clientRect);
                }
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
        this.repaint();
    }

    public int getChartMode() {
        return this.chartMode;
    }

    public void setChartMode(int value) {
        this.chartMode = value;
        this.repaint();
    }

    public String getPieAxisText() {
        return this.pieAxisText;
    }

    public void setPieAxisText(String value) {
        this.pieAxisText = value;
        this.repaint();
    }

    public boolean isPieAxisDrawGrid() {
        return this.pieAxisDrawGrid;
    }

    public void setPieAxisDrawGrid(boolean value) {
        this.pieAxisDrawGrid = value;
        this.repaint();
    }

    public int getPieAxisScaleMode() {
        return this.pieAxisScaleMode;
    }

    public void setPieAxisScaleMode(int value) {
        this.pieAxisScaleMode = value;
        this.repaint();
    }

    public String getXAxisText() {
        return this.xAxisText;
    }

    public void setXAxisText(String value) {
        this.xAxisText = value;
        this.repaint();
    }

    public boolean isAutoCalcXAxis() {
        return this.autoCalcXAxis;
    }

    public void setAutoCalcXAxis(boolean value) {
        this.autoCalcXAxis = value;
        this.repaint();
    }

    public double getXAxisMin() {
        return this.xAxisMin;
    }

    public void setXAxisMin(double value) {
        this.xAxisMin = value;
        if (!this.zoomed) {
            this.xAxisViewMin = this.xAxisMin;
        }
        this.repaint();
    }

    public double getXAxisMax() {
        return this.xAxisMax;
    }

    public void setXAxisMax(double value) {
        this.xAxisMax = value;
        if (!this.zoomed) {
            this.xAxisViewMax = this.xAxisMax;
        }
        this.repaint();
    }

    public boolean isXAxisDrawGrid() {
        return this.xAxisDrawGrid;
    }

    public void setXAxisDrawGrid(boolean value) {
        this.xAxisDrawGrid = value;
        this.repaint();
    }

    public List getXAxisLabels() {
        return this.xAxisLabels;
    }

    public void setXAxisLabels(List value) {
        this.xAxisLabels = value;
        this.repaint();
    }

    public double getXAxisLabelRotation() {
        return this.xAxisLabelRotation;
    }

    public void setXAxisLabelRotation(double value) {
        this.xAxisLabelRotation = value % 360.0;
        this.repaint();
    }

    public String getYAxisText() {
        return this.yAxisText;
    }

    public void setYAxisText(String value) {
        this.yAxisText = value;
        this.repaint();
    }

    public boolean isAutoCalcYAxis() {
        return this.autoCalcYAxis;
    }

    public void setAutoCalcYAxis(boolean value) {
        this.autoCalcYAxis = value;
        this.repaint();
    }

    public double getYAxisMin() {
        return this.yAxisMin;
    }

    public void setYAxisMin(double value) {
        this.yAxisMin = value;
        if (!this.zoomed) {
            this.yAxisViewMin = this.yAxisMin;
        }
        this.repaint();
    }

    public double getYAxisMax() {
        return this.yAxisMax;
    }

    public void setYAxisMax(double value) {
        this.yAxisMax = value;
        if (!this.zoomed) {
            this.yAxisViewMax = this.yAxisMax;
        }
        this.repaint();
    }

    public boolean isYAxisDrawGrid() {
        return this.yAxisDrawGrid;
    }

    public void setYAxisDrawGrid(boolean value) {
        this.yAxisDrawGrid = value;
        this.repaint();
    }

    public List getYAxisLabels() {
        return this.yAxisLabels;
    }

    public void setYAxisLabels(List value) {
        this.yAxisLabels = value;
        this.repaint();
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean value) {
        this.showLegend = value;
        this.repaint();
    }

    public int getFillMode() {
        return this.fillMode;
    }

    public void setFillMode(int value) {
        if (value >= 1 && value <= 3) {
            this.fillMode = value;
            this.repaint();
        }
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color value) {
        this.color1 = value;
        this.repaint();
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color value) {
        this.color2 = value;
        this.repaint();
    }

    public int getGradientDirection() {
        return this.gradientDirection;
    }

    public void setGradientDirection(int value) {
        if (value >= 1 && value <= 8) {
            this.gradientDirection = value;
            this.repaint();
        }
    }

    public int getBarMode() {
        return this.barMode;
    }

    public void setBarMode(int value) {
        this.barMode = value;
        this.repaint();
    }

    public int getAreaMode() {
        return this.areaMode;
    }

    public void setAreaMode(int value) {
        this.areaMode = value;
        this.repaint();
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(boolean value) {
        this.antiAliasing = value;
        this.repaint();
    }

    public boolean isAllowZooming() {
        return this.allowZooming;
    }

    public void setAllowZooming(boolean value) {
        this.allowZooming = value;
        if (!this.allowZooming && !this.allowWheelZooming) {
            this.doUnzoom();
        }
    }

    public boolean isAllowWheelZooming() {
        return this.allowWheelZooming;
    }

    public void setAllowWheelZooming(boolean value) {
        this.allowWheelZooming = value;
        if (!this.allowZooming && !this.allowWheelZooming) {
            this.doUnzoom();
        }
    }

    public boolean isAllowMoving() {
        return this.allowMoving;
    }

    public void setAllowMoving(boolean value) {
        this.allowMoving = value;
    }

    public void addSeries(RswChartSeries aSeries) {
        if (!this.seriesList.contains(aSeries)) {
            if (aSeries.getColor() == null) {
                aSeries.setColor(RswChartColor.getColor(this.seriesList.size()));
            }
            this.seriesList.add(aSeries);
            aSeries.setChart(this);
            this.repaint();
        }
    }

    public void removeSeries(RswChartSeries aSeries) {
        if (this.seriesList.contains(aSeries)) {
            this.seriesList.remove(aSeries);
            this.repaint();
        }
    }

    public int getBarSeriesCount() {
        int i = 0;
        ListIterator it = this.seriesList.listIterator();
        while (it.hasNext()) {
            RswChartSeries tmp = (RswChartSeries)it.next();
            if (!(tmp instanceof RswChartBarSeries)) continue;
            ++i;
        }
        return i;
    }

    private int getBarSeriesIndex(RswChartBarSeries s) {
        int i = 0;
        ListIterator it = this.seriesList.listIterator();
        while (it.hasNext()) {
            RswChartSeries tmp = (RswChartSeries)it.next();
            if (!(tmp instanceof RswChartBarSeries)) continue;
            if (tmp == s) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public double getBarSeriesWidth() {
        double min = 0.0;
        double tmp = 0.0;
        ListIterator it = this.seriesList.listIterator();
        while (it.hasNext()) {
            RswChartSeries s = (RswChartSeries)it.next();
            if (!(s instanceof RswChartBarSeries)) continue;
            tmp = ((RswChartBarSeries)s).getMinDistance();
            if (min != 0.0 && !(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public List getGanttValues() {
        ArrayList tmp = new ArrayList();
        ListIterator it = this.seriesList.listIterator();
        while (it.hasNext()) {
            RswChartSeries s = (RswChartSeries)it.next();
            if (!(s instanceof RswChartGanttSeries)) continue;
            ListIterator it1 = s.values.listIterator();
            while (it1.hasNext()) {
                tmp.add(it1.next());
            }
        }
        return tmp;
    }

    public double getGanttSeriesHeight() {
        double min = 0.0;
        double tmp = 0.0;
        ListIterator it = this.seriesList.listIterator();
        while (it.hasNext()) {
            RswChartSeries s = (RswChartSeries)it.next();
            if (!(s instanceof RswChartGanttSeries)) continue;
            tmp = ((RswChartGanttSeries)s).getMinDistance();
            if (min != 0.0 && !(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public int getAreaSeriesCount() {
        int i = 0;
        ListIterator it = this.seriesList.listIterator();
        while (it.hasNext()) {
            RswChartSeries tmp = (RswChartSeries)it.next();
            if (!(tmp instanceof RswChartAreaSeries)) continue;
            ++i;
        }
        return i;
    }

    private void doZoom(RswChartValue v1, RswChartValue v2) {
        if (v1.getX() >= v2.getX() && v1.getY() <= v2.getY()) {
            this.xAxisViewMin = this.xAxisMin;
            this.xAxisViewMax = this.xAxisMax;
            this.yAxisViewMin = this.yAxisMin;
            this.yAxisViewMax = this.yAxisMax;
            this.zoomed = false;
        } else {
            this.xAxisViewMin = Math.min(v1.getX(), v2.getX());
            this.xAxisViewMax = Math.max(v1.getX(), v2.getX());
            this.yAxisViewMin = Math.min(v1.getY(), v2.getY());
            this.yAxisViewMax = Math.max(v1.getY(), v2.getY());
            this.zoomed = true;
        }
        this.repaint();
    }

    private void doZoomInc(int direction, Point p, Rectangle r) {
        double factor = 0.1;
        if (direction < 1) {
            factor *= -1.0;
        }
        double xMinInc = Math.abs(this.xAxisViewMax - this.xAxisViewMin) * factor * ((double)p.x / (double)r.width);
        double xMaxInc = Math.abs(this.xAxisViewMax - this.xAxisViewMin) * factor * ((double)(r.width - p.x) / (double)r.width);
        double yMinInc = Math.abs(this.yAxisViewMax - this.yAxisViewMin) * factor * ((double)(r.height - p.y) / (double)r.height);
        double yMaxInc = Math.abs(this.yAxisViewMax - this.yAxisViewMin) * factor * ((double)p.y / (double)r.height);
        double newXMin = this.xAxisViewMin + xMinInc;
        double newXMax = this.xAxisViewMax - xMaxInc;
        double newYMin = this.yAxisViewMin + yMinInc;
        double newYMax = this.yAxisViewMax - yMaxInc;
        this.xAxisViewMin = newXMin > this.xAxisMin ? newXMin : this.xAxisMin;
        this.xAxisViewMax = newXMax < this.xAxisMax ? newXMax : this.xAxisMax;
        this.yAxisViewMin = newYMin > this.yAxisMin ? newYMin : this.yAxisMin;
        this.yAxisViewMax = newYMax < this.yAxisMax ? newYMax : this.yAxisMax;
        this.zoomed = this.xAxisViewMin != this.xAxisMin || this.xAxisViewMax != this.xAxisMax || this.yAxisViewMin != this.yAxisMin || this.yAxisViewMax != this.yAxisMax;
        this.repaint();
    }

    private void doMove(RswChartValue val) {
        double dX = -(val.getX() - this.moveVal.getX());
        double dY = -(val.getY() - this.moveVal.getY());
        double dWidth = this.xAxisViewMax - this.xAxisViewMin;
        double dHeight = this.yAxisViewMax - this.yAxisViewMin;
        if (dX > 0.0) {
            this.xAxisViewMax = this.xAxisViewMax + dX < this.xAxisMax ? (this.xAxisViewMax += dX) : this.xAxisMax;
            this.xAxisViewMin = this.xAxisViewMax - dWidth;
        } else {
            this.xAxisViewMin = this.xAxisViewMin + dX > this.xAxisMin ? (this.xAxisViewMin += dX) : this.xAxisMin;
            this.xAxisViewMax = this.xAxisViewMin + dWidth;
        }
        if (dY > 0.0) {
            this.yAxisViewMax = this.yAxisViewMax + dY < this.yAxisMax ? (this.yAxisViewMax += dY) : this.yAxisMax;
            this.yAxisViewMin = this.yAxisViewMax - dHeight;
        } else {
            this.yAxisViewMin = this.yAxisViewMin + dY > this.yAxisMin ? (this.yAxisViewMin += dY) : this.yAxisMin;
            this.yAxisViewMax = this.yAxisViewMin + dHeight;
        }
        this.repaint();
    }

    private void doUnzoom() {
        this.zoomed = false;
        this.xAxisViewMin = this.xAxisMin;
        this.xAxisViewMax = this.xAxisMax;
        this.yAxisViewMin = this.yAxisMin;
        this.yAxisViewMax = this.yAxisMax;
        this.repaint();
    }

    private Point getDrawPoint(double x, double y, Rectangle r) {
        return new Point((int)Math.round((x - this.xAxisViewMin) / (this.xAxisViewMax - this.xAxisViewMin) * (double)r.width) + r.x, r.height - (int)Math.round((y - this.yAxisViewMin) / (this.yAxisViewMax - this.yAxisViewMin) * (double)r.height) + r.y);
    }

    private RswChartValue getValueAt(int x, int y, Rectangle r) {
        return new RswChartValue((double)(x -= r.x) * (this.xAxisViewMax - this.xAxisViewMin) / (double)r.width + this.xAxisViewMin, (double)(r.height - (y -= r.y)) * (this.yAxisViewMax - this.yAxisViewMin) / (double)r.height + this.yAxisViewMin);
    }

    private Rectangle getLegendDrawRect(int x, int y, FontMetrics fm) {
        ListIterator it = this.seriesList.listIterator();
        int maxTextWidth = 0;
        int height = 4;
        while (it.hasNext()) {
            RswChartSeries s = (RswChartSeries)it.next();
            if (fm.stringWidth(s.getName()) > maxTextWidth) {
                maxTextWidth = fm.stringWidth(s.getName());
            }
            height += fm.getHeight() + 1;
        }
        return new Rectangle(x, y, maxTextWidth + 24, height);
    }

    private void drawLegend(Graphics2D g2d, Rectangle r) {
        g2d.setColor(Color.WHITE);
        g2d.fillRect(r.x, r.y, r.width, r.height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(r.x, r.y, r.width, r.height);
        int top = r.y;
        int left = r.x + 5;
        g2d.setFont(this.legendFont);
        FontMetrics fm = g2d.getFontMetrics();
        ListIterator it = this.seriesList.listIterator();
        while (it.hasNext()) {
            RswChartSeries s = (RswChartSeries)it.next();
            Rectangle farbRect = new Rectangle(left, top + (fm.getHeight() - 5) / 2, 10, 10);
            g2d.setColor(s.getColor());
            g2d.fillRect(farbRect.x, farbRect.y, farbRect.width, farbRect.height);
            g2d.setColor(Color.BLACK);
            g2d.drawRect(farbRect.x, farbRect.y, farbRect.width, farbRect.height);
            g2d.drawString(s.getName(), left + 15, top += fm.getHeight() + 1);
        }
    }

    private double roundScale5(double value) {
        return Math.rint(value * 100000.0) / 100000.0;
    }

    private void doAutoCalcAxis() {
        RswChartValuesRect tmp = new RswChartValuesRect(this);
        if (this.autoCalcXAxis) {
            this.xAxisMin = tmp.getMinX();
            this.xAxisMax = tmp.getMaxX();
            if (!this.zoomed) {
                this.xAxisViewMin = this.xAxisMin;
            }
            if (!this.zoomed) {
                this.xAxisViewMax = this.xAxisMax;
            }
        }
        if (this.autoCalcYAxis) {
            this.yAxisMin = tmp.getMinY();
            this.yAxisMax = tmp.getMaxY();
            if (!this.zoomed) {
                this.yAxisViewMin = this.yAxisMin;
            }
            if (!this.zoomed) {
                this.yAxisViewMax = this.yAxisMax;
            }
        }
    }

    private void drawYAxis(Graphics2D g2d, Rectangle r) {
        RswChartAxisScale axisScale = new RswChartAxisScale(this.yAxisViewMin, this.yAxisViewMax, r.height);
        g2d.setStroke(new BasicStroke(1.0f, 0, 2, 1.0f, this.gridLinesDash, 0.0f));
        g2d.setColor(Color.DARK_GRAY);
        Point from = this.getDrawPoint(this.xAxisViewMin, this.yAxisViewMin, r);
        Point to = this.getDrawPoint(this.xAxisViewMax, this.yAxisViewMin, r);
        if (this.pointInRect(from, r) && this.pointInRect(to, r)) {
            g2d.drawLine(from.x, from.y, to.x, to.y);
        }
        from = this.getDrawPoint(this.xAxisViewMin, this.yAxisViewMax, r);
        to = this.getDrawPoint(this.xAxisViewMax, this.yAxisViewMax, r);
        if (this.pointInRect(from, r) && this.pointInRect(to, r)) {
            g2d.drawLine(from.x, from.y, to.x, to.y);
        }
        if (this.yAxisDrawGrid) {
            if (this.yAxisLabels != null) {
                ListIterator it = this.yAxisLabels.listIterator();
                while (it.hasNext()) {
                    RswChartAxisLabel l = (RswChartAxisLabel)it.next();
                    from = this.getDrawPoint(this.xAxisViewMin, l.getP(), r);
                    to = this.getDrawPoint(this.xAxisViewMax, l.getP(), r);
                    if (!this.pointInRect(from, r) || !this.pointInRect(to, r)) continue;
                    g2d.drawLine(from.x, from.y, to.x, to.y);
                }
            } else {
                for (double tmp = this.roundScale5(this.yAxisViewMax - Math.IEEEremainder(this.yAxisViewMax, axisScale.getScale())); tmp >= this.yAxisMin; tmp -= axisScale.getScale()) {
                    from = this.getDrawPoint(this.xAxisViewMin, tmp, r);
                    to = this.getDrawPoint(this.xAxisViewMax, tmp, r);
                    if (!this.pointInRect(from, r) || !this.pointInRect(to, r)) continue;
                    g2d.drawLine(from.x, from.y, to.x, to.y);
                }
            }
        }
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.BLACK);
        double xP = 0.0;
        if (this.xAxisViewMin > 0.0) {
            xP = this.xAxisViewMin;
        } else if (this.xAxisViewMax < 0.0) {
            xP = this.xAxisViewMax;
        }
        Point top = this.getDrawPoint(xP, this.yAxisViewMax, r);
        Point bottom = this.getDrawPoint(xP, this.yAxisViewMin, r);
        g2d.setColor(Color.BLACK);
        g2d.drawLine(top.x, top.y, bottom.x, bottom.y);
        g2d.setFont(this.labelFont);
        FontMetrics fm = g2d.getFontMetrics();
        if (this.yAxisLabels != null) {
            ListIterator it = this.yAxisLabels.listIterator();
            while (it.hasNext()) {
                RswChartAxisLabel l = (RswChartAxisLabel)it.next();
                Point p = this.getDrawPoint(xP, l.getP(), r);
                if (!this.pointInRect(p, r)) continue;
                g2d.drawLine(p.x - 4, p.y, p.x + 4, p.y);
                int fOffSet = fm.stringWidth(l.getLabel()) + 5;
                g2d.drawString(l.getLabel(), p.x - fOffSet, p.y + (fm.getHeight() - 5) / 2);
            }
        } else {
            for (double tmp = this.roundScale5(this.yAxisViewMax - Math.IEEEremainder(this.yAxisViewMax, axisScale.getScale())); tmp >= this.yAxisViewMin; tmp -= axisScale.getScale()) {
                Point p = this.getDrawPoint(xP, tmp, r);
                if (this.roundScale5(tmp) == 0.0) continue;
                if (this.roundScale5(tmp) % (axisScale.getScale() * 5.0) == 0.0) {
                    if (!this.pointInRect(p, r)) continue;
                    g2d.drawLine(p.x - 4, p.y, p.x + 4, p.y);
                    String lbl = new DecimalFormat(axisScale.getDecimalFormatString()).format(tmp);
                    int fOffSet = fm.stringWidth(lbl) + 5;
                    g2d.drawString(lbl, p.x - fOffSet, p.y + (fm.getHeight() - 5) / 2);
                    continue;
                }
                if (!this.pointInRect(p, r)) continue;
                g2d.drawLine(p.x - 2, p.y, p.x + 2, p.y);
            }
        }
    }

    private void drawXAxis(Graphics2D g2d, Rectangle r) {
        RswChartAxisScale axisScale = new RswChartAxisScale(this.xAxisViewMin, this.xAxisViewMax, r.width);
        g2d.setStroke(new BasicStroke(1.0f, 0, 2, 1.0f, this.gridLinesDash, 0.0f));
        g2d.setColor(Color.DARK_GRAY);
        Point from = this.getDrawPoint(this.xAxisViewMin, this.yAxisViewMin, r);
        Point to = this.getDrawPoint(this.xAxisViewMin, this.yAxisViewMax, r);
        if (this.pointInRect(from, r) && this.pointInRect(to, r)) {
            g2d.drawLine(from.x, from.y, to.x, to.y);
        }
        from = this.getDrawPoint(this.xAxisViewMax, this.yAxisViewMin, r);
        to = this.getDrawPoint(this.xAxisViewMax, this.yAxisViewMax, r);
        if (this.pointInRect(from, r) && this.pointInRect(to, r)) {
            g2d.drawLine(from.x, from.y, to.x, to.y);
        }
        if (this.xAxisDrawGrid) {
            if (this.xAxisLabels != null) {
                ListIterator it = this.xAxisLabels.listIterator();
                while (it.hasNext()) {
                    RswChartAxisLabel l = (RswChartAxisLabel)it.next();
                    from = this.getDrawPoint(l.getP(), this.yAxisViewMin, r);
                    to = this.getDrawPoint(l.getP(), this.yAxisViewMax, r);
                    if (!this.pointInRect(from, r) || !this.pointInRect(to, r)) continue;
                    g2d.drawLine(from.x, from.y, to.x, to.y);
                }
            } else {
                for (double tmp = this.roundScale5(this.xAxisViewMax - Math.IEEEremainder(this.xAxisViewMax, axisScale.getScale())); tmp >= this.xAxisMin; tmp -= axisScale.getScale()) {
                    from = this.getDrawPoint(tmp, this.yAxisViewMin, r);
                    to = this.getDrawPoint(tmp, this.yAxisViewMax, r);
                    if (!this.pointInRect(from, r) || !this.pointInRect(to, r)) continue;
                    g2d.drawLine(from.x, from.y, to.x, to.y);
                }
            }
        }
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.BLACK);
        double yP = 0.0;
        if (this.yAxisViewMin > 0.0) {
            yP = this.yAxisViewMin;
        } else if (this.yAxisViewMax < 0.0) {
            yP = this.yAxisViewMax;
        }
        Point left = this.getDrawPoint(this.xAxisViewMin, yP, r);
        Point right = this.getDrawPoint(this.xAxisViewMax, yP, r);
        g2d.setColor(Color.BLACK);
        g2d.drawLine(left.x, left.y, right.x, right.y);
        g2d.setFont(this.labelFont);
        FontMetrics fm = g2d.getFontMetrics();
        if (this.xAxisLabels != null) {
            ListIterator it = this.xAxisLabels.listIterator();
            while (it.hasNext()) {
                RswChartAxisLabel l = (RswChartAxisLabel)it.next();
                Point p = this.getDrawPoint(l.getP(), yP, r);
                if (!this.pointInRect(p, r)) continue;
                g2d.drawLine(p.x, p.y - 4, p.x, p.y + 4);
                int fOffSet = fm.stringWidth(l.getLabel()) / 2;
                if (this.xAxisLabelRotation != 0.0) {
                    p.y += 10;
                    g2d.rotate(Math.toRadians(this.xAxisLabelRotation), p.x, p.y);
                    g2d.drawString(l.getLabel(), p.x, p.y);
                    g2d.rotate(Math.toRadians(-this.xAxisLabelRotation), p.x, p.y);
                    continue;
                }
                g2d.drawString(l.getLabel(), p.x - fOffSet, p.y + fm.getHeight() + 2);
            }
        } else {
            for (double tmp = this.roundScale5(this.xAxisViewMax - Math.IEEEremainder(this.xAxisViewMax, axisScale.getScale())); tmp >= this.xAxisViewMin; tmp -= axisScale.getScale()) {
                Point p = this.getDrawPoint(tmp, yP, r);
                if (this.roundScale5(tmp) == 0.0) continue;
                if (this.roundScale5(tmp) % (axisScale.getScale() * 5.0) == 0.0) {
                    if (!this.pointInRect(p, r)) continue;
                    g2d.drawLine(p.x, p.y - 4, p.x, p.y + 4);
                    String lbl = new DecimalFormat(axisScale.getDecimalFormatString()).format(tmp);
                    int fOffSet = fm.stringWidth(lbl) / 2;
                    if (this.xAxisLabelRotation != 0.0) {
                        p.y += 10;
                        g2d.rotate(Math.toRadians(this.xAxisLabelRotation), p.x, p.y);
                        g2d.drawString(lbl, p.x, p.y);
                        g2d.rotate(Math.toRadians(-this.xAxisLabelRotation), p.x, p.y);
                        continue;
                    }
                    g2d.drawString(lbl, p.x - fOffSet, p.y + fm.getHeight() + 2);
                    continue;
                }
                if (!this.pointInRect(p, r)) continue;
                g2d.drawLine(p.x, p.y - 2, p.x, p.y + 2);
            }
        }
    }

    private Point getPieScalePoint(Rectangle r, Double angle) {
        Point tmp = null;
        angle = angle % 360.0;
        int radius = 0;
        radius = angle <= 45.0 || angle > 135.0 && angle <= 225.0 || angle > 315.0 ? r.width / 2 : r.height / 2;
        int i = 0;
        while (angle > 45.0) {
            angle = angle - 90.0;
            ++i;
        }
        if (i == 0) {
            tmp = new Point((int)Math.ceil((double)(r.x + r.width / 2) + (double)radius * Math.tan(Math.toRadians(angle))), r.y);
        } else if (i == 1) {
            tmp = new Point(r.x + r.width, (int)Math.ceil((double)(r.y + r.height / 2) + (double)radius * Math.tan(Math.toRadians(angle))));
        } else if (i == 2) {
            tmp = new Point((int)Math.ceil((double)(r.x + r.width / 2) - (double)radius * Math.tan(Math.toRadians(angle))), r.y + r.height);
        } else if (i == 3) {
            tmp = new Point(r.x, (int)Math.ceil((double)(r.y + r.height / 2) - (double)radius * Math.tan(Math.toRadians(angle))));
        } else if (i == 4) {
            tmp = new Point((int)Math.ceil((double)(r.x + r.width / 2) + (double)radius * Math.tan(Math.toRadians(angle))), r.y);
        }
        return tmp;
    }

    private void drawPieAxis(Graphics2D g2d, Rectangle r) {
        g2d.setStroke(new BasicStroke(1.0f, 0, 2, 1.0f, this.gridLinesDash, 0.0f));
        g2d.setColor(Color.DARK_GRAY);
        g2d.draw(r);
        g2d.setFont(this.labelFont);
        FontMetrics fm = g2d.getFontMetrics();
        RswChartAxisScale axisScale = new RswChartAxisScale(this.pieAxisMin, this.pieAxisMax, 2 * (r.width + r.height));
        Point from = new Point(r.x + r.width / 2, r.y + r.height / 2);
        double tmp = this.pieAxisMin;
        double a = 0.0;
        while (tmp < this.pieAxisMax) {
            a = tmp * 360.0 / this.pieAxisMax;
            Point to = this.getPieScalePoint(r, a);
            if (to == null) continue;
            if (this.pieAxisDrawGrid) {
                g2d.drawLine(from.x, from.y, to.x, to.y);
            }
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(1.0f));
            boolean drawLbl = this.pieAxisScaleMode > 1 || this.roundScale5(tmp) % (axisScale.getScale() * 5.0) == 0.0;
            int nOffset = 0;
            nOffset = drawLbl ? 4 : 2;
            String lbl = new DecimalFormat(axisScale.getDecimalFormatString()).format(tmp);
            if (this.pieAxisScaleMode > 1) {
                lbl = lbl + " %";
            }
            int xOffset = 0;
            int yOffset = 0;
            if (to.y == r.y) {
                xOffset = -fm.stringWidth(lbl) / 2;
                yOffset = -6;
                g2d.drawLine(to.x, to.y, to.x, to.y - nOffset);
            } else if (to.y == r.y + r.height) {
                xOffset = -fm.stringWidth(lbl) / 2;
                yOffset = 4 + fm.getHeight();
                g2d.drawLine(to.x, to.y, to.x, to.y + nOffset);
            } else if (to.x == r.x + r.width) {
                xOffset = 6;
                yOffset = (fm.getHeight() - 5) / 2;
                g2d.drawLine(to.x, to.y, to.x + nOffset, to.y);
            } else if (to.x == r.x) {
                xOffset = -fm.stringWidth(lbl) - 6;
                yOffset = (fm.getHeight() - 5) / 2;
                g2d.drawLine(to.x, to.y, to.x - nOffset, to.y);
            }
            g2d.setStroke(oldStroke);
            if (drawLbl) {
                g2d.drawString(lbl, to.x + xOffset, to.y + yOffset);
            }
            if (this.pieAxisScaleMode == 1) {
                tmp += axisScale.getScale();
                continue;
            }
            if (this.pieAxisScaleMode == 2) {
                tmp += 5.0;
                continue;
            }
            if (this.pieAxisScaleMode == 3) {
                tmp += 10.0;
                continue;
            }
            if (this.pieAxisScaleMode != 4) continue;
            tmp += 25.0;
        }
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.BLACK);
    }

    private boolean pointInRect(Point p, Rectangle r) {
        return p.x >= r.x && p.x <= r.x + r.width && p.y >= r.y && p.y <= r.y + r.height;
    }

    private boolean barInRect(Point p, Rectangle r) {
        return p.x >= r.x && p.x <= r.x + r.width;
    }

    private void drawDot(Graphics2D g2d, Color color, Point p, int dotType) {
        switch (dotType) {
            case 1: {
                g2d.setColor(color);
                g2d.fillOval(p.x - 3, p.y - 3, 6, 6);
                g2d.setColor(Color.BLACK);
                g2d.drawOval(p.x - 3, p.y - 3, 6, 6);
                break;
            }
            case 2: {
                g2d.setColor(color);
                g2d.fillRect(p.x - 3, p.y - 3, 6, 6);
                g2d.setColor(Color.BLACK);
                g2d.drawRect(p.x - 3, p.y - 3, 6, 6);
                break;
            }
            case 3: {
                GeneralPath path = new GeneralPath();
                path.moveTo(p.x - 4, p.y);
                path.lineTo(p.x, p.y - 4);
                path.lineTo(p.x + 4, p.y);
                path.lineTo(p.x, p.y + 4);
                path.lineTo(p.x - 4, p.y);
                path.closePath();
                g2d.setColor(color);
                g2d.fill(path);
                g2d.setColor(Color.BLACK);
                g2d.draw(path);
                break;
            }
            case 4: {
                GeneralPath path = new GeneralPath();
                path.moveTo(p.x - 4, p.y);
                path.lineTo(p.x + 4, p.y);
                path.moveTo(p.x, p.y - 4);
                path.lineTo(p.x, p.y + 4);
                path.moveTo(p.x - 3, p.y - 3);
                path.lineTo(p.x + 3, p.y + 3);
                path.moveTo(p.x - 3, p.y + 3);
                path.lineTo(p.x + 3, p.y - 3);
                g2d.setColor(color);
                g2d.draw(path);
            }
        }
    }

    private void drawValueLabel(Graphics2D g2d, Point p, String label) {
        if (!label.equals("")) {
            g2d.setFont(this.labelFont);
            FontMetrics fm = g2d.getFontMetrics();
            int w = fm.stringWidth(label);
            Rectangle r = new Rectangle(p.x - 3 - w / 2, p.y - 10 - fm.getHeight() - 2, w + 4, fm.getHeight() + 2);
            g2d.setColor(new Color(255, 255, 223));
            g2d.fill(r);
            g2d.setColor(Color.BLACK);
            g2d.draw(r);
            g2d.drawString(label, r.x + 3, r.y + r.height - 2);
            g2d.drawLine(p.x, p.y, p.x, p.y - 10);
        }
    }

    private void drawSeries(RswChartSeries s, Graphics2D g2d, Rectangle r, double barChartWidth) {
        if (s.isVisible()) {
            RswChartValue v;
            Rectangle rect;
            ListIterator it;
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, s.getAlpha()));
            if (s instanceof RswChartDotSeries) {
                it = s.values.listIterator();
                while (it.hasNext()) {
                    RswChartValue v2 = (RswChartValue)it.next();
                    Point p = this.getDrawPoint(v2.getX(), v2.getY(), r);
                    if (!((RswChartDotSeries)s).getDrawDots()) continue;
                    this.drawDot(g2d, s.getColor(), p, ((RswChartDotSeries)s).getDotType());
                }
            }
            if (s instanceof RswChartLineSeries) {
                Point p;
                RswChartValue v3;
                it = s.values.listIterator();
                GeneralPath path = new GeneralPath();
                if (it.hasNext()) {
                    v3 = (RswChartValue)it.next();
                    p = this.getDrawPoint(v3.getX(), v3.getY(), r);
                    path.moveTo(p.x, p.y);
                }
                while (it.hasNext()) {
                    v3 = (RswChartValue)it.next();
                    p = this.getDrawPoint(v3.getX(), v3.getY(), r);
                    path.lineTo(p.x, p.y);
                }
                g2d.setColor(s.getColor());
                Stroke oldStroke = g2d.getStroke();
                g2d.setStroke(((RswChartLineSeries)s).getStroke());
                g2d.draw(path);
                g2d.setStroke(oldStroke);
            }
            if (s instanceof RswChartBarSeries) {
                int barIndex = 0;
                int barCount = 1;
                if (this.barMode == 3) {
                    barIndex = this.getBarSeriesIndex((RswChartBarSeries)s);
                    barCount = this.getBarSeriesCount();
                }
                double barDistance = barChartWidth;
                double barWidth = barDistance / (double)barCount;
                double barOffSet = barDistance / 2.0;
                ListIterator it2 = s.values.listIterator();
                while (it2.hasNext()) {
                    RswChartValue v4 = (RswChartValue)it2.next();
                    if (this.barMode == 2) {
                        v4 = ((RswChartBarSeries)s).getStackedValue(v4.getX());
                    }
                    Point pLeft = this.getDrawPoint(v4.getX() + (double)barIndex * barWidth - barOffSet, v4.getY(), r);
                    Point pLeft0 = this.getDrawPoint(v4.getX() + (double)barIndex * barWidth - barOffSet, 0.0, r);
                    Point pRight = this.getDrawPoint(v4.getX() + (double)(barIndex + 1) * barWidth - barOffSet, v4.getY(), r);
                    Point pRight0 = this.getDrawPoint(v4.getX() + (double)(barIndex + 1) * barWidth - barOffSet, 0.0, r);
                    rect = pLeft.y < pLeft0.y ? new Rectangle(pLeft.x, pLeft.y, pRight.x - pLeft.x, pLeft0.y - pLeft.y) : new Rectangle(pLeft0.x, pLeft0.y, pRight0.x - pLeft0.x, pLeft.y - pLeft0.y);
                    RswChartFillSeries fs = (RswChartFillSeries)s;
                    GradientPaint gp = null;
                    if (fs.isGradientFill()) {
                        gp = this.getGradientPaint(fs.getColor(), Color.WHITE, fs.getGradientDirection(), rect);
                    }
                    if (gp != null) {
                        g2d.setPaint(gp);
                    } else {
                        g2d.setColor(s.getColor());
                    }
                    g2d.fill(rect);
                    g2d.setPaint(null);
                    g2d.setColor(Color.BLACK);
                    g2d.draw(rect);
                }
            }
            if (s instanceof RswChartAreaSeries) {
                ListIterator it3 = s.values.listIterator();
                RswChartValue lastVal = null;
                RswChartValue curVal = null;
                if (it3.hasNext()) {
                    v = (RswChartValue)it3.next();
                    if (this.areaMode == 2) {
                        v = ((RswChartAreaSeries)s).getStackedValue(v.getX());
                    }
                    Point p = this.getDrawPoint(v.getX(), v.getY(), r);
                    lastVal = v;
                }
                while (it3.hasNext()) {
                    v = (RswChartValue)it3.next();
                    if (this.areaMode == 2) {
                        v = ((RswChartAreaSeries)s).getStackedValue(v.getX());
                    }
                    Point p = this.getDrawPoint(v.getX(), v.getY(), r);
                    curVal = v;
                    if (lastVal != null && curVal != null) {
                        Point lastP = this.getDrawPoint(lastVal.getX(), lastVal.getY(), r);
                        Point lastP0 = this.getDrawPoint(lastVal.getX(), 0.0, r);
                        Point curP = this.getDrawPoint(curVal.getX(), curVal.getY(), r);
                        Point curP0 = this.getDrawPoint(curVal.getX(), 0.0, r);
                        GeneralPath path = new GeneralPath();
                        path.moveTo(lastP.x, lastP.y);
                        path.lineTo(curP.x, curP.y);
                        path.lineTo(curP0.x, curP0.y);
                        path.lineTo(lastP0.x, lastP0.y);
                        path.lineTo(lastP.x, lastP.y);
                        path.closePath();
                        RswChartFillSeries fs = (RswChartFillSeries)s;
                        GradientPaint gp = null;
                        if (fs.isGradientFill()) {
                            int top = Math.min(lastP.y, curP.y);
                            int height = Math.abs(lastP0.y - top);
                            rect = new Rectangle(lastP.x, top, curP.x - lastP.x, height);
                            gp = this.getGradientPaint(fs.getColor(), Color.WHITE, fs.getGradientDirection(), rect);
                        }
                        if (gp != null) {
                            g2d.setPaint(gp);
                        } else {
                            g2d.setColor(s.getColor());
                        }
                        g2d.fill(path);
                        g2d.setPaint(null);
                        g2d.setColor(Color.BLACK);
                        g2d.draw(path);
                    }
                    lastVal = curVal;
                }
            }
            if (s instanceof RswChartGanttSeries) {
                double ganttHeight = this.getGanttSeriesHeight();
                ListIterator it4 = s.values.listIterator();
                while (it4.hasNext()) {
                    v = (RswChartValue)it4.next();
                    Point pLeft = this.getDrawPoint(v.getX(), v.getY() + ganttHeight / 2.0, r);
                    Point pLeft0 = this.getDrawPoint(v.getX(), v.getY() - ganttHeight / 2.0, r);
                    Point pRight = this.getDrawPoint(v.getX() + v.getWidth(), v.getY() + ganttHeight / 2.0, r);
                    Point pRight0 = this.getDrawPoint(v.getX() + v.getWidth(), v.getY() - ganttHeight / 2.0, r);
                    Rectangle rect2 = new Rectangle(pLeft.x, pLeft.y, pRight.x - pLeft.x, pLeft0.y - pLeft.y);
                    RswChartFillSeries fs = (RswChartFillSeries)s;
                    GradientPaint gp = null;
                    if (fs.isGradientFill()) {
                        gp = this.getGradientPaint(fs.getColor(), Color.WHITE, fs.getGradientDirection(), rect2);
                    }
                    if (gp != null) {
                        g2d.setPaint(gp);
                    } else {
                        g2d.setColor(s.getColor());
                    }
                    g2d.fill(rect2);
                    g2d.setPaint(null);
                    g2d.setColor(Color.BLACK);
                    g2d.draw(rect2);
                }
            }
            if (s instanceof RswChartBubbleSeries) {
                ListIterator it5 = s.values.listIterator();
                while (it5.hasNext()) {
                    RswChartValue v5 = (RswChartValue)it5.next();
                    Point pLeft = this.getDrawPoint(v5.getX() - v5.getWidth() / 2.0, v5.getY() + v5.getWidth() / 2.0, r);
                    Point pRight0 = this.getDrawPoint(v5.getX() + v5.getWidth() / 2.0, v5.getY() - v5.getWidth() / 2.0, r);
                    if (((RswChartBubbleSeries)s).getAlwaysCircles()) {
                        int h;
                        int w = Math.abs(pRight0.x - pLeft.x);
                        if (w < (h = Math.abs(pRight0.y - pLeft.y))) {
                            pLeft.y += (h - w) / 2;
                            pRight0.y -= (h - w) / 2;
                        } else if (w > h) {
                            pLeft.x += (w - h) / 2;
                            pRight0.x -= (w - h) / 2;
                        }
                    }
                    Rectangle rect3 = new Rectangle(pLeft.x, pLeft.y, pRight0.x - pLeft.x, pRight0.y - pLeft.y);
                    RswChartFillSeries fs = (RswChartFillSeries)s;
                    GradientPaint gp = null;
                    if (fs.isGradientFill()) {
                        gp = this.getGradientPaint(fs.getColor(), Color.WHITE, fs.getGradientDirection(), rect3);
                    }
                    if (gp != null) {
                        g2d.setPaint(gp);
                    } else {
                        g2d.setColor(s.getColor());
                    }
                    g2d.fillOval(pLeft.x, pLeft.y, pRight0.x - pLeft.x, pRight0.y - pLeft.y);
                    g2d.setPaint(null);
                    g2d.setColor(Color.BLACK);
                    g2d.drawOval(pLeft.x, pLeft.y, pRight0.x - pLeft.x, pRight0.y - pLeft.y);
                }
            }
            g2d.setComposite(oldComposite);
        }
    }

    private GradientPaint getGradientPaint(Color color1, Color color2, int direction, Rectangle r) {
        Point from = new Point(r.x + r.width / 2, r.y);
        Point to = new Point(r.x + r.width / 2, r.y + r.height);
        switch (direction) {
            case 1: {
                from = new Point(r.x + r.width / 2, r.y);
                to = new Point(r.x + r.width / 2, r.y + r.height);
                break;
            }
            case 2: {
                from = new Point(r.x + r.width / 2, r.y + r.height);
                to = new Point(r.x + r.width / 2, r.y);
                break;
            }
            case 3: {
                from = new Point(r.x, r.y + r.height / 2);
                to = new Point(r.x + r.width, r.y + r.height / 2);
                break;
            }
            case 4: {
                from = new Point(r.x + r.width, r.y + r.height / 2);
                to = new Point(r.x, r.y + r.height / 2);
                break;
            }
            case 5: {
                from = new Point(r.x, r.y);
                to = new Point(r.x + r.width, r.y + r.height);
                break;
            }
            case 6: {
                from = new Point(r.x + r.width, r.y);
                to = new Point(r.x, r.y + r.height);
                break;
            }
            case 7: {
                from = new Point(r.x, r.y + r.height);
                to = new Point(r.x + r.width, r.y);
                break;
            }
            case 8: {
                from = new Point(r.x + r.width, r.y + r.height);
                to = new Point(r.x, r.y);
            }
        }
        return new GradientPaint(from.x, from.y, color1, to.x, to.y, color2);
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x = this.getSize().width;
        int y = this.getSize().height;
        this.doPaintOnGraphics2D(g2d, x, y);
    }

    private void doPaintOnGraphics2D(Graphics2D g2d, int x, int y) {
        if (this.chartMode == 1) {
            RswChartAxisScale as;
            RswChartAxisLabel l;
            ListIterator it;
            int titleOffSet = 25;
            this.xlabelOffSet = new Point(0, 25);
            this.ylabelOffSet = new Point(25, 0);
            if (this.antiAliasing) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.autoCalcXAxis || this.autoCalcYAxis) {
                this.doAutoCalcAxis();
            }
            FontMetrics fm = null;
            int maxWidth = 0;
            double tmpY = 0.0;
            double tmpX = 0.0;
            fm = g2d.getFontMetrics(this.labelFont);
            if (this.xAxisLabels != null) {
                it = this.xAxisLabels.listIterator();
                while (it.hasNext()) {
                    l = (RswChartAxisLabel)it.next();
                    if (fm.stringWidth(l.getLabel()) <= maxWidth) continue;
                    maxWidth = fm.stringWidth(l.getLabel());
                }
            } else {
                as = new RswChartAxisScale(this.xAxisViewMin, this.xAxisViewMax, x);
                maxWidth = fm.stringWidth(as.getMaxLabel());
            }
            if (Math.ceil(tmpY = Math.abs(Math.sin(Math.toRadians(this.xAxisLabelRotation)) * (double)maxWidth)) + 10.0 > (double)this.xlabelOffSet.y) {
                this.xlabelOffSet.y = (int)Math.ceil(tmpY) + 10;
            }
            if (Math.ceil(tmpX = Math.abs(Math.cos(Math.toRadians(this.xAxisLabelRotation)) * (double)maxWidth)) + 5.0 > (double)this.xlabelOffSet.x) {
                this.xlabelOffSet.x = (int)Math.ceil(tmpX) + 5;
            }
            maxWidth = 0;
            tmpY = 0.0;
            tmpX = 0.0;
            if (this.yAxisLabels != null) {
                it = this.yAxisLabels.listIterator();
                while (it.hasNext()) {
                    l = (RswChartAxisLabel)it.next();
                    if (fm.stringWidth(l.getLabel()) <= maxWidth) continue;
                    maxWidth = fm.stringWidth(l.getLabel());
                }
            } else {
                as = new RswChartAxisScale(this.yAxisViewMin, this.yAxisViewMax, y);
                maxWidth = fm.stringWidth(as.getMaxLabel());
            }
            if (Math.ceil(tmpY = Math.abs(Math.sin(Math.toRadians(0.0)) * (double)maxWidth)) + 10.0 > (double)this.ylabelOffSet.y) {
                this.ylabelOffSet.y = (int)Math.ceil(tmpY) + 10;
            }
            if (Math.ceil(tmpX = Math.abs(Math.cos(Math.toRadians(0.0)) * (double)maxWidth)) + 5.0 > (double)this.ylabelOffSet.x) {
                this.ylabelOffSet.x = (int)Math.ceil(tmpX) + 5;
            }
            g2d.setFont(this.titleFont);
            fm = g2d.getFontMetrics();
            this.titleRect = new Rectangle(0, 0, x, fm.getHeight() + 5 + titleOffSet);
            this.legendRect = null;
            Rectangle legendDrawRect = null;
            if (this.showLegend && this.seriesList.size() > 0) {
                g2d.setFont(this.legendFont);
                fm = g2d.getFontMetrics();
                legendDrawRect = this.getLegendDrawRect(0, 0, fm);
                this.legendRect = new Rectangle(x - legendDrawRect.width - 10, this.titleRect.height, Math.max(this.xlabelOffSet.x, legendDrawRect.width + 10), y - this.titleRect.height);
                legendDrawRect.x = this.legendRect.x + 5;
                legendDrawRect.y = this.legendRect.y;
            } else {
                this.legendRect = new Rectangle(x, this.titleRect.height, Math.max(this.xlabelOffSet.x, 10), y - this.titleRect.height);
            }
            g2d.setFont(this.axisFont);
            fm = g2d.getFontMetrics();
            this.xAxisRect = new Rectangle(fm.getHeight() + 5 + this.xlabelOffSet.y, y - fm.getHeight() - 5 - this.xlabelOffSet.y, x - fm.getHeight() - 5 - this.ylabelOffSet.x - this.legendRect.width, fm.getHeight() + 5 + this.xlabelOffSet.y);
            g2d.setFont(this.axisFont);
            fm = g2d.getFontMetrics();
            this.yAxisRect = new Rectangle(0, this.titleRect.height, fm.getHeight() + 5 + this.ylabelOffSet.x, y - this.titleRect.height - this.xAxisRect.height);
            this.clientRect = new Rectangle(this.yAxisRect.width, this.titleRect.height, x - this.yAxisRect.width - this.legendRect.width, y - this.titleRect.height - this.xAxisRect.height);
            if (this.fillMode != 1) {
                if (this.fillMode == 2) {
                    g2d.setColor(this.color1);
                    g2d.fill(this.clientRect);
                } else if (this.fillMode == 3) {
                    Point from = this.getDrawPoint(this.xAxisMin, this.yAxisMax, this.clientRect);
                    Point to = this.getDrawPoint(this.xAxisMax, this.yAxisMin, this.clientRect);
                    g2d.setPaint(this.getGradientPaint(this.color1, this.color2, this.gradientDirection, new Rectangle(from.x, from.y, Math.abs(to.x - from.x), Math.abs(from.y - to.y))));
                    g2d.fill(this.clientRect);
                    g2d.setPaint(null);
                }
            }
            this.drawXAxis(g2d, this.clientRect);
            this.drawYAxis(g2d, this.clientRect);
            g2d.setClip(this.clientRect);
            ListIterator it2 = this.seriesList.listIterator();
            while (it2.hasNext()) {
                it2.next();
            }
            while (it2.hasPrevious()) {
                this.drawSeries((RswChartSeries)it2.previous(), g2d, this.clientRect, this.getBarSeriesWidth());
            }
            g2d.setClip(null);
            it2 = this.seriesList.listIterator();
            while (it2.hasNext()) {
                it2.next();
            }
            while (it2.hasPrevious()) {
                RswChartSeries s = (RswChartSeries)it2.previous();
                if (!s.isVisible()) continue;
                Composite oldComposite = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(3, s.getAlpha()));
                if (s.isShowValueLables()) {
                    ListIterator itV = s.values.listIterator();
                    while (itV.hasNext()) {
                        Point p;
                        RswChartValue v = (RswChartValue)itV.next();
                        String lbl = v.getLabel();
                        if (s instanceof RswChartBarSeries && this.barMode == 2 || s instanceof RswChartAreaSeries && this.areaMode == 2) {
                            v = ((RswChartStackableSeries)s).getStackedValue(v.getX());
                        }
                        if (!this.pointInRect(p = this.getDrawPoint(v.getX(), v.getY(), this.clientRect), this.clientRect)) continue;
                        this.drawValueLabel(g2d, p, lbl);
                    }
                }
                g2d.setComposite(oldComposite);
            }
            int w = 0;
            g2d.setFont(this.titleFont);
            fm = g2d.getFontMetrics();
            w = fm.stringWidth(this.title);
            g2d.setColor(Color.BLACK);
            g2d.drawString(this.title, (this.titleRect.width - this.titleRect.x) / 2 - w / 2, fm.getHeight());
            if (this.showLegend && this.seriesList.size() > 0) {
                this.drawLegend(g2d, legendDrawRect);
            }
            g2d.setFont(this.axisFont);
            fm = g2d.getFontMetrics();
            String aXAxisText = this.xAxisText;
            if (this.zoomed) {
                double zoomPercent = Math.abs(this.xAxisViewMax - this.xAxisViewMin) / Math.abs(this.xAxisMax - this.xAxisMin) * 100.0;
                aXAxisText = aXAxisText + " (zoomed " + new DecimalFormat("#,##0.00").format(zoomPercent) + "%)";
            }
            w = fm.stringWidth(aXAxisText);
            g2d.setColor(Color.BLACK);
            g2d.drawString(aXAxisText, this.xAxisRect.width / 2 + this.yAxisRect.width - w / 2, this.xAxisRect.y + fm.getHeight() + this.xlabelOffSet.y);
            g2d.setFont(this.axisFont);
            fm = g2d.getFontMetrics();
            String aYAxisText = this.yAxisText;
            if (this.zoomed) {
                double zoomPercent = Math.abs(this.yAxisViewMax - this.yAxisViewMin) / Math.abs(this.yAxisMax - this.yAxisMin) * 100.0;
                aYAxisText = aYAxisText + " (zoomed " + new DecimalFormat("#,##0.00").format(zoomPercent) + "%)";
            }
            w = fm.stringWidth(aYAxisText);
            g2d.rotate(Math.toRadians(90.0));
            g2d.drawString(aYAxisText, (this.yAxisRect.height + this.yAxisRect.y + this.titleRect.height) / 2 - w / 2, -5);
            g2d.rotate(Math.toRadians(-90.0));
            if (this.selectingZoom && this.selectedZoomRect != null) {
                g2d.setColor(Color.BLUE);
                g2d.setStroke(new BasicStroke(2.0f, 0, 2, 1.0f, this.selectZoomDash, 0.0f));
                g2d.draw(this.selectedZoomRect);
            }
        } else {
            int titleOffSet = 25;
            if (this.antiAliasing) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            FontMetrics fm = null;
            g2d.setFont(this.axisFont);
            fm = g2d.getFontMetrics();
            int pieAxisOffset = fm.getHeight() + 10;
            g2d.setFont(this.labelFont);
            fm = g2d.getFontMetrics();
            String maxLabel = "100%";
            this.xlabelOffSet = new Point(0, fm.getHeight() + 10 + pieAxisOffset);
            this.ylabelOffSet = new Point(fm.stringWidth(maxLabel) + 10, 0);
            g2d.setFont(this.titleFont);
            fm = g2d.getFontMetrics();
            this.titleRect = new Rectangle(0, 0, x, fm.getHeight() + 5 + titleOffSet);
            this.legendRect = null;
            Rectangle legendDrawRect = null;
            if (this.showLegend && this.seriesList.size() > 0) {
                g2d.setFont(this.legendFont);
                fm = g2d.getFontMetrics();
                legendDrawRect = this.getLegendDrawRect(0, 0, fm);
                this.legendRect = new Rectangle(x - legendDrawRect.width - 10, this.titleRect.height, Math.max(this.xlabelOffSet.x, legendDrawRect.width + 10), y - this.titleRect.height);
                legendDrawRect.x = this.legendRect.x + 5;
                legendDrawRect.y = this.legendRect.y;
            } else {
                this.legendRect = new Rectangle(x, this.titleRect.height, Math.max(this.xlabelOffSet.x, 10), y - this.titleRect.height);
            }
            this.xAxisRect = new Rectangle(this.xlabelOffSet.y, y - this.xlabelOffSet.y, x - this.ylabelOffSet.x - this.legendRect.width, this.xlabelOffSet.y);
            this.yAxisRect = new Rectangle(0, this.titleRect.height, this.ylabelOffSet.x, y - this.titleRect.height - this.xAxisRect.height);
            this.clientRect = new Rectangle(this.yAxisRect.width, this.titleRect.height, x - 2 * this.yAxisRect.width - this.legendRect.width, y - this.titleRect.height - this.xAxisRect.height);
            if (this.fillMode != 1) {
                if (this.fillMode == 2) {
                    g2d.setColor(this.color1);
                    g2d.fill(this.clientRect);
                } else if (this.fillMode == 3) {
                    g2d.setPaint(this.getGradientPaint(this.color1, this.color2, this.gradientDirection, this.clientRect));
                    g2d.fill(this.clientRect);
                    g2d.setPaint(null);
                }
            }
            double valSum = 0.0;
            ListIterator it = this.seriesList.listIterator();
            while (it.hasNext()) {
                RswChartSeries s = (RswChartSeries)it.next();
                if (!s.isVisible()) continue;
                valSum += s.getPieValue();
            }
            this.pieAxisMin = 0.0;
            this.pieAxisMax = this.pieAxisScaleMode == 1 ? valSum : 100.0;
            this.drawPieAxis(g2d, this.clientRect);
            double startArc = 90.0;
            double curArc = 0.0;
            it = this.seriesList.listIterator();
            while (it.hasNext()) {
                it.next();
            }
            while (it.hasPrevious()) {
                RswChartSeries s = (RswChartSeries)it.previous();
                if (!s.isVisible()) continue;
                Composite oldComposite = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(3, s.getAlpha()));
                curArc = s.getPieValue() * 360.0 / valSum;
                Arc2D.Double arc = new Arc2D.Double(this.clientRect.x + 20, this.clientRect.y + 20, this.clientRect.width - 40, this.clientRect.height - 40, startArc, curArc, 2);
                g2d.setColor(s.getColor());
                g2d.fill(arc);
                g2d.setColor(Color.BLACK);
                g2d.draw(arc);
                startArc += curArc;
                g2d.setComposite(oldComposite);
            }
            int w = 0;
            g2d.setFont(this.titleFont);
            fm = g2d.getFontMetrics();
            w = fm.stringWidth(this.title);
            g2d.setColor(Color.BLACK);
            g2d.drawString(this.title, (this.titleRect.width - this.titleRect.x) / 2 - w / 2, fm.getHeight());
            if (this.showLegend && this.seriesList.size() > 0) {
                this.drawLegend(g2d, legendDrawRect);
            }
            g2d.setFont(this.labelFont);
            fm = g2d.getFontMetrics();
            int labelOffset = fm.getHeight() + 10;
            g2d.setFont(this.axisFont);
            fm = g2d.getFontMetrics();
            String aPieAxisText = this.pieAxisText;
            w = fm.stringWidth(aPieAxisText);
            g2d.setColor(Color.BLACK);
            g2d.drawString(aPieAxisText, this.xAxisRect.width / 2 + this.ylabelOffSet.x / 2 - w / 2, this.xAxisRect.y + fm.getHeight() + labelOffset);
        }
    }

    public BufferedImage getImage() {
        Dimension size = this.getSize();
        if (size.width == 0 || size.height == 0) {
            size = this.getPreferredSize();
        }
        return this.getImage(size.width, size.height);
    }

    public BufferedImage getImage(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2d = img.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        this.doPaintOnGraphics2D(g2d, width, height);
        return img;
    }

    public void saveAsJPegFile(String filename) {
        Dimension size = this.getSize();
        if (size.width == 0 || size.height == 0) {
            size = this.getPreferredSize();
        }
        this.saveAsJPegFile(filename, size.width, size.height);
    }

    public void saveAsJPegFile(String filename, int width, int height) {
        BufferedImage img = this.getImage(width, height);
        try {
            FileOutputStream out = new FileOutputStream(filename);
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            encoder.encode(img);
            out.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
        }
    }

    public JDialog getEditor() {
        Frame f = null;
        return new RswChartEditorFrame(this, f, true);
    }

    public JDialog getEditor(Frame parentFrame) {
        return new RswChartEditorFrame(this, parentFrame, true);
    }

    public JDialog getEditor(Dialog owner) {
        return new RswChartEditorFrame(this, owner, true);
    }
}

