/*
 * Decompiled with CFR 0.152.
 */
package rswchartexample;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import rsw.chart.RswChart;
import rsw.chart.RswChartAreaSeries;
import rsw.chart.RswChartAxisLabel;
import rsw.chart.RswChartBarSeries;
import rsw.chart.RswChartBubbleSeries;
import rsw.chart.RswChartDotSeries;
import rsw.chart.RswChartGanttSeries;
import rsw.chart.RswChartLineSeries;
import rswchartexample.AboutFrame;
import rswchartexample.ImageSelection;

public class MainFrame
extends JFrame {
    private RswChart theChart = null;
    private JMenuItem aboutMenuItem;
    private JMenuItem areaDemoMenuItem;
    private JMenuItem barDemoNormalMenuItem;
    private JMenuItem barDemoSideMenuItem;
    private JMenuItem barDemoStackedMenuItem;
    private JMenuItem bubbleDemoMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem configureChartMenuItem;
    private JMenuItem copyFixedSizeMenuItem;
    private JMenuItem copyMenuItem;
    private JMenu demosMenu;
    private JMenuItem dotDemoMenuItem;
    private JMenu editMenu;
    private JMenu fileMenu;
    private JMenuItem ganttDemoMenuItem;
    private JMenu helpMenu;
    private JSeparator jSeparator1;
    private JMenuItem lineDemoMenuItem;
    private JMenuBar mainMenuBar;

    public MainFrame() {
        this.initComponents();
        this.doDotChart();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        this.setLocation(new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2));
    }

    private void doClose() {
        this.dispose();
        System.exit(0);
    }

    private void doDotChart() {
        RswChart chart;
        Dimension size = null;
        if (this.theChart != null) {
            size = this.theChart.getSize();
            this.getContentPane().remove(this.theChart);
            this.theChart = null;
        }
        this.theChart = chart = new RswChart(size);
        chart.setTitle("Dot chart demo");
        chart.setXAxisText("x");
        chart.setYAxisText("f(x)");
        for (int i = 1; i < 5; ++i) {
            RswChartDotSeries s = new RswChartDotSeries("f(x) = x^" + i);
            switch (i) {
                case 1: {
                    s.setDotType(1);
                    break;
                }
                case 2: {
                    s.setDotType(2);
                    break;
                }
                case 3: {
                    s.setDotType(3);
                    break;
                }
                case 4: {
                    s.setDotType(4);
                }
            }
            s.setShowValueLabels(true);
            s.setAlpha(0.5f);
            for (double d = -1.0; d <= 1.0; d += 0.1) {
                s.addXY(d, Math.pow(d, i));
            }
            chart.addSeries(s);
        }
        this.getContentPane().add((Component)chart, "Center");
        this.pack();
    }

    private void doLineChart() {
        RswChart chart;
        Dimension size = null;
        if (this.theChart != null) {
            size = this.theChart.getSize();
            this.getContentPane().remove(this.theChart);
            this.theChart = null;
        }
        this.theChart = chart = new RswChart(size);
        chart.setTitle("Line chart demo");
        chart.setXAxisText("x");
        chart.setYAxisText("f(x)");
        for (int i = 1; i < 5; ++i) {
            RswChartLineSeries s = new RswChartLineSeries("f(x) = x^" + i);
            for (double d = -1.0; d <= 1.0; d += 0.01) {
                s.addXY(d, Math.pow(d, i));
            }
            chart.addSeries(s);
        }
        this.getContentPane().add((Component)chart, "Center");
        this.pack();
    }

    private void doAreaChart() {
        RswChart chart;
        Dimension size = null;
        if (this.theChart != null) {
            size = this.theChart.getSize();
            this.getContentPane().remove(this.theChart);
            this.theChart = null;
        }
        this.theChart = chart = new RswChart(size);
        chart.setTitle("Area chart demo (bycicle height profile)");
        chart.setXAxisText("Distance in kilometers");
        chart.setYAxisText("Height in meters");
        RswChartAreaSeries s1 = new RswChartAreaSeries("My tour", new Color(0, 0, 92));
        s1.setGradientFill(true);
        s1.setGradientDirection(RswChart.GRADIENT_DIRECTION_NORTH_TO_SOUTH);
        s1.setShowValueLabels(true);
        s1.setAlpha(0.8f);
        RswChartAreaSeries s2 = new RswChartAreaSeries("Alpe d'Huez", new Color(0, 92, 0));
        s2.setGradientFill(true);
        s2.setGradientDirection(RswChart.GRADIENT_DIRECTION_NORTH_TO_SOUTH);
        s2.setShowValueLabels(true);
        s2.setAlpha(0.8f);
        ArrayList<RswChartAxisLabel> xAxisLabels = new ArrayList<RswChartAxisLabel>();
        chart.setXAxisLabels(xAxisLabels);
        chart.setXAxisLabelRotation(45.0);
        s1.addXYLabel(0.0, 117.0, "117 m");
        xAxisLabels.add(new RswChartAxisLabel(0.0, "0 km"));
        s1.addXYLabel(4.0, 130.0, "130 m");
        xAxisLabels.add(new RswChartAxisLabel(4.0, "4 km"));
        s1.addXYLabel(8.5, 189.0, "189 m");
        xAxisLabels.add(new RswChartAxisLabel(8.5, "8.5 km"));
        s1.addXYLabel(12.5, 79.0, "79 m");
        xAxisLabels.add(new RswChartAxisLabel(12.5, "12.5 km"));
        s1.addXYLabel(14.0, 117.0, "117 m");
        xAxisLabels.add(new RswChartAxisLabel(14.0, "14 km"));
        s2.addXYLabel(0.0, 717.0, "717 m");
        s2.addXYLabel(4.0, 980.0, "980 m");
        s2.addXYLabel(8.5, 1475.0, "1.475 m");
        s2.addXYLabel(12.5, 1785.0, "1.785 m");
        s2.addXYLabel(14.0, 1860.0, "1.860 m");
        chart.addSeries(s1);
        chart.addSeries(s2);
        this.getContentPane().add((Component)chart, "Center");
        this.pack();
    }

    private void doBarChart(boolean sideMode) {
        RswChart chart;
        Dimension size = null;
        if (this.theChart != null) {
            size = this.theChart.getSize();
            this.getContentPane().remove(this.theChart);
            this.theChart = null;
        }
        this.theChart = chart = new RswChart(size);
        chart.setTitle("Bar chart demo (students income in NRW 1996 and 2004)");
        chart.setXAxisText("Kind of income");
        chart.setYAxisText("Percentage weighting");
        if (sideMode) {
            chart.setBarMode(3);
        } else {
            chart.setBarMode(1);
        }
        chart.setAutoCalcYAxis(false);
        chart.setYAxisMin(0.0);
        chart.setYAxisMax(100.0);
        RswChartBarSeries s1996 = new RswChartBarSeries("1996");
        s1996.setShowValueLabels(true);
        RswChartBarSeries s2004 = new RswChartBarSeries("2004");
        s2004.setShowValueLabels(true);
        ArrayList<RswChartAxisLabel> xAxisLabels = new ArrayList<RswChartAxisLabel>();
        chart.setXAxisLabels(xAxisLabels);
        chart.setXAxisLabelRotation(45.0);
        s1996.addXY(1.0, 15.7);
        s2004.addXY(1.0, 20.8);
        xAxisLabels.add(new RswChartAxisLabel(1.0, "Income by job"));
        s1996.addXY(2.0, 69.5);
        s2004.addXY(2.0, 64.0);
        xAxisLabels.add(new RswChartAxisLabel(2.0, "Income by parents"));
        s1996.addXY(3.0, 12.3);
        s2004.addXY(3.0, 12.6);
        xAxisLabels.add(new RswChartAxisLabel(3.0, "Income by scholarship"));
        s1996.addXY(4.0, 2.5);
        s2004.addXY(4.0, 2.5);
        xAxisLabels.add(new RswChartAxisLabel(4.0, "Other income"));
        chart.addSeries(s1996);
        chart.addSeries(s2004);
        this.getContentPane().add((Component)chart, "Center");
        this.pack();
    }

    private void doBarStackedChart() {
        RswChart chart;
        Dimension size = null;
        if (this.theChart != null) {
            size = this.theChart.getSize();
            this.getContentPane().remove(this.theChart);
            this.theChart = null;
        }
        this.theChart = chart = new RswChart(size);
        chart.setTitle("Bar chart demo (students income in NRW 1996 and 2004)");
        chart.setXAxisText("Year");
        chart.setYAxisText("Percentage weighting");
        chart.setBarMode(2);
        RswChartBarSeries sJob = new RswChartBarSeries("Income by job");
        sJob.setShowValueLabels(true);
        RswChartBarSeries sParents = new RswChartBarSeries("Income by parents");
        sParents.setShowValueLabels(true);
        RswChartBarSeries sScholarship = new RswChartBarSeries("Income by scholarship");
        sScholarship.setShowValueLabels(true);
        RswChartBarSeries sOther = new RswChartBarSeries("Other income");
        sOther.setShowValueLabels(true);
        ArrayList<RswChartAxisLabel> xAxisLabels = new ArrayList<RswChartAxisLabel>();
        chart.setXAxisLabels(xAxisLabels);
        chart.setXAxisLabelRotation(45.0);
        sJob.addXY(1.0, 15.7);
        sJob.addXY(2.0, 20.8);
        sParents.addXY(1.0, 69.5);
        sParents.addXY(2.0, 64.0);
        sScholarship.addXY(1.0, 12.3);
        sScholarship.addXY(2.0, 12.6);
        sOther.addXY(1.0, 2.5);
        sOther.addXY(2.0, 2.5);
        xAxisLabels.add(new RswChartAxisLabel(1.0, "1996"));
        xAxisLabels.add(new RswChartAxisLabel(2.0, "2004"));
        chart.addSeries(sJob);
        chart.addSeries(sParents);
        chart.addSeries(sScholarship);
        chart.addSeries(sOther);
        this.getContentPane().add((Component)chart, "Center");
        this.pack();
    }

    private void doGanttChart() {
        RswChart chart;
        Dimension size = null;
        if (this.theChart != null) {
            size = this.theChart.getSize();
            this.getContentPane().remove(this.theChart);
            this.theChart = null;
        }
        this.theChart = chart = new RswChart(size);
        chart.setTitle("Gantt chart demo (project with tasks and progress)");
        chart.setColor1(Color.WHITE);
        chart.setFillMode(2);
        chart.setXAxisText("Date in calendar weeks");
        chart.setYAxisText("Tasks");
        chart.setYAxisDrawGrid(false);
        RswChartGanttSeries s100 = new RswChartGanttSeries("100% done", new Color(0, 192, 0));
        s100.setAlpha(0.8f);
        RswChartGanttSeries s50 = new RswChartGanttSeries("50% done", new Color(224, 224, 0));
        s50.setAlpha(0.8f);
        RswChartGanttSeries s0 = new RswChartGanttSeries("0% done", new Color(192, 0, 0));
        s0.setAlpha(0.8f);
        RswChartAreaSeries sWeekends = new RswChartAreaSeries("Weekends", new Color(192, 192, 192));
        sWeekends.setAlpha(0.3f);
        RswChartLineSeries sToday = new RswChartLineSeries("Today", new Color(0, 0, 192));
        sToday.setShowValueLabels(true);
        sToday.setStroke(new BasicStroke(3.0f));
        sToday.setAlpha(0.8f);
        ArrayList<RswChartAxisLabel> yAxisLabels = new ArrayList<RswChartAxisLabel>();
        chart.setYAxisLabels(yAxisLabels);
        yAxisLabels.add(new RswChartAxisLabel(5.0, "Designing"));
        yAxisLabels.add(new RswChartAxisLabel(4.0, "Programming"));
        yAxisLabels.add(new RswChartAxisLabel(3.0, "Testing"));
        yAxisLabels.add(new RswChartAxisLabel(2.0, "Documantion"));
        yAxisLabels.add(new RswChartAxisLabel(1.0, "Roll out"));
        chart.setAutoCalcYAxis(false);
        chart.setYAxisMin(0.2);
        chart.setYAxisMax(5.8);
        ArrayList<RswChartAxisLabel> xAxisLabels = new ArrayList<RswChartAxisLabel>();
        chart.setXAxisLabels(xAxisLabels);
        chart.setXAxisLabelRotation(45.0);
        int i = 1;
        GregorianCalendar lastDay = new GregorianCalendar();
        lastDay.add(5, 14);
        GregorianCalendar curDay = new GregorianCalendar();
        curDay.add(5, -31);
        GregorianCalendar today = new GregorianCalendar();
        while (curDay.compareTo(lastDay) <= 0) {
            if (curDay.get(7) == 2) {
                xAxisLabels.add(new RswChartAxisLabel(i, "Cw " + curDay.get(3) + " " + curDay.get(1)));
            } else {
                xAxisLabels.add(new RswChartAxisLabel(i, ""));
            }
            if (curDay.get(7) == 7) {
                sWeekends.addXY(i, 0.0);
                sWeekends.addXY(i, 6.0);
            }
            if (curDay.get(7) == 2) {
                sWeekends.addXY(i, 6.0);
                sWeekends.addXY(i, 0.0);
            }
            if (curDay.get(1) == today.get(1) && curDay.get(2) == today.get(2) && curDay.get(5) == today.get(5)) {
                sToday.addXYLabel(i, chart.getYAxisMin(), "");
                sToday.addXYLabel(i, chart.getYAxisMax(), "Today");
            }
            ++i;
            curDay.add(5, 1);
        }
        s100.addXYWidth(1.0, 5.0, 10.0);
        s100.addXYWidth(6.0, 4.0, 24.0);
        s50.addXYWidth(21.0, 3.0, 18.0);
        s0.addXYWidth(30.0, 2.0, 10.0);
        s0.addXYWidth(40.0, 1.0, 5.0);
        chart.addSeries(sToday);
        chart.addSeries(s100);
        chart.addSeries(s50);
        chart.addSeries(s0);
        chart.addSeries(sWeekends);
        this.getContentPane().add((Component)chart, "Center");
        this.pack();
    }

    private void doBubbleChart() {
        RswChart chart;
        Dimension size = null;
        if (this.theChart != null) {
            size = this.theChart.getSize();
            this.getContentPane().remove(this.theChart);
            this.theChart = null;
        }
        this.theChart = chart = new RswChart(size);
        chart.setTitle("Bubble chart demo (profit and costs per year)");
        chart.setColor1(Color.LIGHT_GRAY);
        chart.setFillMode(3);
        chart.setGradientDirection(RswChart.GRADIENT_DIRECTION_SOUTHEAST_TO_NORTHWEST);
        chart.setXAxisText("Financial year");
        chart.setYAxisText("Product");
        RswChartBubbleSeries sProfit = new RswChartBubbleSeries("Profit (in 1,000 $)", new Color(0, 192, 0));
        sProfit.setAlpha(0.7f);
        sProfit.setShowValueLabels(true);
        RswChartBubbleSeries sCosts = new RswChartBubbleSeries("Costs (in 1,000 $)", new Color(192, 0, 0));
        sCosts.setAlpha(0.7f);
        sCosts.setShowValueLabels(true);
        ArrayList<RswChartAxisLabel> yAxisLabels = new ArrayList<RswChartAxisLabel>();
        chart.setYAxisLabels(yAxisLabels);
        yAxisLabels.add(new RswChartAxisLabel(500.0, "Pizza"));
        yAxisLabels.add(new RswChartAxisLabel(400.0, "Hamburger"));
        yAxisLabels.add(new RswChartAxisLabel(300.0, "Quarter pounder"));
        yAxisLabels.add(new RswChartAxisLabel(200.0, "Chicken wings"));
        yAxisLabels.add(new RswChartAxisLabel(100.0, "Soft drinks"));
        ArrayList<RswChartAxisLabel> xAxisLabels = new ArrayList<RswChartAxisLabel>();
        chart.setXAxisLabels(xAxisLabels);
        xAxisLabels.add(new RswChartAxisLabel(100.0, "2002"));
        xAxisLabels.add(new RswChartAxisLabel(200.0, "2003"));
        xAxisLabels.add(new RswChartAxisLabel(300.0, "2004"));
        xAxisLabels.add(new RswChartAxisLabel(400.0, "2005"));
        sProfit.addXYWidthLabel(110.0, 510.0, 52.0, "52");
        sCosts.addXYWidthLabel(90.0, 490.0, 12.0, "12");
        sProfit.addXYWidthLabel(110.0, 410.0, 60.0, "60");
        sCosts.addXYWidthLabel(90.0, 390.0, 21.0, "21");
        sProfit.addXYWidthLabel(110.0, 310.0, 35.0, "35");
        sCosts.addXYWidthLabel(90.0, 290.0, 12.0, "12");
        sProfit.addXYWidthLabel(110.0, 110.0, 37.0, "37");
        sCosts.addXYWidthLabel(90.0, 90.0, 5.0, "5");
        sProfit.addXYWidthLabel(210.0, 510.0, 71.0, "71");
        sCosts.addXYWidthLabel(190.0, 490.0, 20.0, "20");
        sProfit.addXYWidthLabel(210.0, 410.0, 57.0, "57");
        sCosts.addXYWidthLabel(190.0, 390.0, 30.0, "30");
        sProfit.addXYWidthLabel(210.0, 310.0, 21.0, "21");
        sCosts.addXYWidthLabel(190.0, 290.0, 13.0, "13");
        sProfit.addXYWidthLabel(210.0, 110.0, 28.0, "28");
        sCosts.addXYWidthLabel(190.0, 90.0, 3.0, "3");
        sProfit.addXYWidthLabel(310.0, 510.0, 80.0, "80");
        sCosts.addXYWidthLabel(290.0, 490.0, 25.0, "25");
        sProfit.addXYWidthLabel(310.0, 410.0, 50.0, "50");
        sCosts.addXYWidthLabel(290.0, 390.0, 30.0, "30");
        sProfit.addXYWidthLabel(310.0, 210.0, 15.0, "15");
        sCosts.addXYWidthLabel(290.0, 190.0, 10.0, "10");
        sProfit.addXYWidthLabel(310.0, 110.0, 32.0, "32");
        sCosts.addXYWidthLabel(290.0, 90.0, 7.0, "7");
        sProfit.addXYWidthLabel(410.0, 510.0, 69.0, "69");
        sCosts.addXYWidthLabel(390.0, 490.0, 24.0, "24");
        sProfit.addXYWidthLabel(410.0, 410.0, 62.0, "62");
        sCosts.addXYWidthLabel(390.0, 390.0, 39.0, "39");
        sProfit.addXYWidthLabel(410.0, 210.0, 85.0, "85");
        sCosts.addXYWidthLabel(390.0, 190.0, 41.0, "41");
        sProfit.addXYWidthLabel(410.0, 110.0, 36.0, "36");
        sCosts.addXYWidthLabel(390.0, 90.0, 9.0, "9");
        chart.addSeries(sProfit);
        chart.addSeries(sCosts);
        this.getContentPane().add((Component)chart, "Center");
        this.pack();
    }

    private void initComponents() {
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.closeMenuItem = new JMenuItem();
        this.demosMenu = new JMenu();
        this.dotDemoMenuItem = new JMenuItem();
        this.lineDemoMenuItem = new JMenuItem();
        this.areaDemoMenuItem = new JMenuItem();
        this.barDemoNormalMenuItem = new JMenuItem();
        this.barDemoSideMenuItem = new JMenuItem();
        this.barDemoStackedMenuItem = new JMenuItem();
        this.ganttDemoMenuItem = new JMenuItem();
        this.bubbleDemoMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.configureChartMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.copyMenuItem = new JMenuItem();
        this.copyFixedSizeMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Rsw Chart Example");
        this.fileMenu.setText("File");
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.mainMenuBar.add(this.fileMenu);
        this.demosMenu.setText("Demos");
        this.dotDemoMenuItem.setText("Dot chart demo");
        this.dotDemoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.dotDemoMenuItemActionPerformed(evt);
            }
        });
        this.demosMenu.add(this.dotDemoMenuItem);
        this.lineDemoMenuItem.setText("Line chart demo");
        this.lineDemoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.lineDemoMenuItemActionPerformed(evt);
            }
        });
        this.demosMenu.add(this.lineDemoMenuItem);
        this.areaDemoMenuItem.setText("Area chart demo");
        this.areaDemoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.areaDemoMenuItemActionPerformed(evt);
            }
        });
        this.demosMenu.add(this.areaDemoMenuItem);
        this.barDemoNormalMenuItem.setText("Bar chart demo (normal mode)");
        this.barDemoNormalMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.barDemoNormalMenuItemActionPerformed(evt);
            }
        });
        this.demosMenu.add(this.barDemoNormalMenuItem);
        this.barDemoSideMenuItem.setText("Bar chart demo (side mode)");
        this.barDemoSideMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.barDemoSideMenuItemActionPerformed(evt);
            }
        });
        this.demosMenu.add(this.barDemoSideMenuItem);
        this.barDemoStackedMenuItem.setText("Bar chart demo (stacked mode)");
        this.barDemoStackedMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.barDemoStackedMenuItemActionPerformed(evt);
            }
        });
        this.demosMenu.add(this.barDemoStackedMenuItem);
        this.ganttDemoMenuItem.setText("Gantt chart demo");
        this.ganttDemoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.ganttDemoMenuItemActionPerformed(evt);
            }
        });
        this.demosMenu.add(this.ganttDemoMenuItem);
        this.bubbleDemoMenuItem.setText("Bubble chart demo");
        this.bubbleDemoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.bubbleDemoMenuItemActionPerformed(evt);
            }
        });
        this.demosMenu.add(this.bubbleDemoMenuItem);
        this.mainMenuBar.add(this.demosMenu);
        this.editMenu.setText("Edit");
        this.configureChartMenuItem.setText("Configure chart...");
        this.configureChartMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.configureChartMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.configureChartMenuItem);
        this.editMenu.add(this.jSeparator1);
        this.copyMenuItem.setText("Copy to clipboard");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.copyFixedSizeMenuItem.setText("Copy to clipboard (fixed size)");
        this.copyFixedSizeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.copyFixedSizeMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyFixedSizeMenuItem);
        this.mainMenuBar.add(this.editMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About RswChart...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.mainMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.mainMenuBar);
        this.pack();
    }

    private void copyFixedSizeMenuItemActionPerformed(ActionEvent evt) {
        if (this.theChart != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            ImageSelection imgSel = new ImageSelection(this.theChart.getImage(800, 600));
            cb.setContents(imgSel, null);
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new AboutFrame((Frame)this, true).setVisible(true);
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        if (this.theChart != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            ImageSelection imgSel = new ImageSelection(this.theChart.getImage());
            cb.setContents(imgSel, null);
        }
    }

    private void bubbleDemoMenuItemActionPerformed(ActionEvent evt) {
        this.doBubbleChart();
    }

    private void ganttDemoMenuItemActionPerformed(ActionEvent evt) {
        this.doGanttChart();
    }

    private void barDemoStackedMenuItemActionPerformed(ActionEvent evt) {
        this.doBarStackedChart();
    }

    private void barDemoSideMenuItemActionPerformed(ActionEvent evt) {
        this.doBarChart(true);
    }

    private void barDemoNormalMenuItemActionPerformed(ActionEvent evt) {
        this.doBarChart(false);
    }

    private void dotDemoMenuItemActionPerformed(ActionEvent evt) {
        this.doDotChart();
    }

    private void areaDemoMenuItemActionPerformed(ActionEvent evt) {
        this.doAreaChart();
    }

    private void lineDemoMenuItemActionPerformed(ActionEvent evt) {
        this.doLineChart();
    }

    private void configureChartMenuItemActionPerformed(ActionEvent evt) {
        if (this.theChart != null) {
            JDialog f = this.theChart.getEditor(this);
            f.setVisible(true);
            this.repaint();
        }
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }
}

