/*
 * Decompiled with CFR 0.152.
 */
package rsw.chart;

import java.util.ListIterator;
import rsw.chart.RswChart;
import rsw.chart.RswChartAreaSeries;
import rsw.chart.RswChartBarSeries;
import rsw.chart.RswChartBubbleSeries;
import rsw.chart.RswChartGanttSeries;
import rsw.chart.RswChartSeries;
import rsw.chart.RswChartStackableSeries;
import rsw.chart.RswChartValue;

public class RswChartValuesRect {
    double minX = 0.0;
    double minY = 0.0;
    double maxX = 0.0;
    double maxY = 0.0;

    public RswChartValuesRect(RswChart chart) {
        boolean initialized = false;
        if (chart != null && chart.seriesList != null) {
            ListIterator seriesIt = chart.seriesList.listIterator();
            double barOffSet = chart.getBarSeriesWidth() / 2.0;
            double ganttOffSet = chart.getGanttSeriesHeight() / 2.0;
            while (seriesIt.hasNext()) {
                RswChartValue v;
                RswChartSeries s = (RswChartSeries)seriesIt.next();
                ListIterator it = s.values.listIterator();
                if (!initialized && it.hasNext()) {
                    v = (RswChartValue)it.next();
                    if (s instanceof RswChartBarSeries && s.getChart().getBarMode() == 2 || s instanceof RswChartAreaSeries && chart.getAreaMode() == 2) {
                        v = ((RswChartStackableSeries)s).getStackedValue(v.getX());
                    }
                    if (s instanceof RswChartBarSeries) {
                        this.minX = v.getX() - barOffSet;
                        this.maxX = v.getX() + barOffSet;
                        this.minY = v.getY();
                        this.maxY = v.getY();
                    } else if (s instanceof RswChartGanttSeries) {
                        this.minX = v.getX();
                        this.maxX = v.getX() + v.getWidth();
                        this.minY = v.getY() - ganttOffSet;
                        this.maxY = v.getY() + ganttOffSet;
                    } else if (s instanceof RswChartBubbleSeries) {
                        this.minX = v.getX() - v.getWidth() / 2.0;
                        this.maxX = v.getX() + v.getWidth() / 2.0;
                        this.minY = v.getY() - v.getWidth() / 2.0;
                        this.maxY = v.getY() + v.getWidth() / 2.0;
                    } else {
                        this.minX = v.getX();
                        this.maxX = v.getX();
                        this.minY = v.getY();
                        this.maxY = v.getY();
                    }
                    initialized = true;
                }
                while (it.hasNext()) {
                    v = (RswChartValue)it.next();
                    if (s instanceof RswChartBarSeries && s.getChart().getBarMode() == 2 || s instanceof RswChartAreaSeries && s.getChart().getAreaMode() == 2) {
                        v = ((RswChartStackableSeries)s).getStackedValue(v.getX());
                    }
                    if (s instanceof RswChartBarSeries) {
                        if (v.getX() - barOffSet < this.minX) {
                            this.minX = v.getX() - barOffSet;
                        }
                        if (v.getX() + barOffSet > this.maxX) {
                            this.maxX = v.getX() + barOffSet;
                        }
                        if (v.getY() < this.minY) {
                            this.minY = v.getY();
                        }
                        if (!(v.getY() > this.maxY)) continue;
                        this.maxY = v.getY();
                        continue;
                    }
                    if (s instanceof RswChartGanttSeries) {
                        if (v.getX() < this.minX) {
                            this.minX = v.getX();
                        }
                        if (v.getX() + v.getWidth() > this.maxX) {
                            this.maxX = v.getX() + v.getWidth();
                        }
                        if (v.getY() - ganttOffSet < this.minY) {
                            this.minY = v.getY() - ganttOffSet;
                        }
                        if (!(v.getY() + ganttOffSet > this.maxY)) continue;
                        this.maxY = v.getY() + ganttOffSet;
                        continue;
                    }
                    if (s instanceof RswChartBubbleSeries) {
                        if (v.getX() - v.getWidth() / 2.0 < this.minX) {
                            this.minX = v.getX() - v.getWidth() / 2.0;
                        }
                        if (v.getX() + v.getWidth() / 2.0 > this.maxX) {
                            this.maxX = v.getX() + v.getWidth() / 2.0;
                        }
                        if (v.getY() - v.getWidth() / 2.0 < this.minY) {
                            this.minY = v.getY() - v.getWidth() / 2.0;
                        }
                        if (!(v.getY() + v.getWidth() / 2.0 > this.maxY)) continue;
                        this.maxY = v.getY() + v.getWidth() / 2.0;
                        continue;
                    }
                    if (v.getX() < this.minX) {
                        this.minX = v.getX();
                    }
                    if (v.getX() > this.maxX) {
                        this.maxX = v.getX();
                    }
                    if (v.getY() < this.minY) {
                        this.minY = v.getY();
                    }
                    if (!(v.getY() > this.maxY)) continue;
                    this.maxY = v.getY();
                }
                if (chart.getBarSeriesCount() <= 0 && chart.getAreaSeriesCount() <= 0) continue;
                if (this.minY > 0.0) {
                    this.minY = 0.0;
                }
                if (!(this.maxY < 0.0)) continue;
                this.maxY = 0.0;
            }
        }
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }
}

