/*
 * Decompiled with CFR 0.152.
 */
package rsw.chart;

import java.text.DecimalFormat;

public class RswChartAxisScale {
    double scale;
    int pixelPerScale;
    String maxLabel;

    public RswChartAxisScale(double aScale, int aPixelPerScale, String aMaxLabel) {
        this.scale = aScale;
        this.pixelPerScale = aPixelPerScale;
        this.maxLabel = aMaxLabel;
    }

    public RswChartAxisScale(double aMin, double aMax, int aPixels) {
        double all = Math.abs(aMax - aMin);
        if (all == 0.0) {
            this.scale = 0.0;
            this.pixelPerScale = 0;
            this.maxLabel = "";
        } else {
            this.scale = 1.0E-5;
            long scaleCount = Math.round(all / this.scale);
            while ((long)aPixels / scaleCount < 10L) {
                this.scale *= 10.0;
                scaleCount = Math.round(all / this.scale);
            }
            this.pixelPerScale = (int)((long)aPixels / scaleCount);
            double tmp = 0.0;
            tmp = Math.abs(aMax) > Math.abs(aMin) ? -1.0 * Math.abs(aMax - aMax % this.scale) : -1.0 * Math.abs(aMin - aMin % this.scale);
            this.maxLabel = new DecimalFormat(this.getDecimalFormatString()).format(tmp);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double value) {
        this.scale = value;
    }

    public int getPixelPerScale() {
        return this.pixelPerScale;
    }

    public void setPixelPerScale(int value) {
        this.pixelPerScale = value;
    }

    public String getMaxLabel() {
        return this.maxLabel;
    }

    public void setMaxLabel(String value) {
        this.maxLabel = value;
    }

    public String getDecimalFormatString() {
        String tmp = "#,##0";
        if (this.scale > 0.0) {
            double i = 1.0;
            if (i > this.scale) {
                tmp = tmp + ".";
            }
            while (i > this.scale) {
                tmp = tmp + "0";
                i /= 10.0;
            }
        }
        return tmp;
    }
}

